/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowComputeNodesStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.proxy.ProxyInstanceMetaData;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowComputeNodesExecutor
implements DistSQLQueryExecutor<ShowComputeNodesStatement> {
    public Collection<String> getColumnNames(ShowComputeNodesStatement sqlStatement) {
        return Arrays.asList("instance_id", "instance_type", "host", "port", "status", "mode_type", "worker_id", "labels", "version", "database_name");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowComputeNodesStatement sqlStatement, ContextManager contextManager) {
        String modeType = contextManager.getComputeNodeInstanceContext().getModeConfiguration().getType();
        return "Standalone".equals(modeType) ? Collections.singleton(this.buildRow(contextManager.getComputeNodeInstanceContext().getInstance(), modeType)) : (Collection)contextManager.getPersistServiceFacade().getComputeNodePersistService().loadAllInstances().stream().map(each -> this.buildRow((ComputeNodeInstance)each, modeType)).collect(Collectors.toList());
    }

    private LocalDataQueryResultRow buildRow(ComputeNodeInstance instance, String modeType) {
        String labels = String.join((CharSequence)",", instance.getLabels());
        InstanceMetaData instanceMetaData = instance.getMetaData();
        return new LocalDataQueryResultRow(new Object[]{instanceMetaData.getId(), instanceMetaData.getType(), instanceMetaData.getIp(), instanceMetaData instanceof ProxyInstanceMetaData ? ((ProxyInstanceMetaData)instanceMetaData).getPort() : -1, instance.getState().getCurrentState(), modeType, instance.getWorkerId(), labels, instanceMetaData.getVersion(), instanceMetaData.getDatabaseName()});
    }

    public Class<ShowComputeNodesStatement> getType() {
        return ShowComputeNodesStatement.class;
    }
}

