/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.authentication.authenticator.impl;

import java.util.Arrays;
import org.apache.shardingsphere.db.protocol.opengauss.constant.OpenGaussAuthenticationMethod;
import org.apache.shardingsphere.db.protocol.opengauss.packet.authentication.OpenGaussMacCalculator;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.proxy.frontend.opengauss.authentication.authenticator.OpenGaussAuthenticator;

public final class OpenGaussSCRAMSha256PasswordAuthenticator
implements OpenGaussAuthenticator {
    public boolean authenticate(ShardingSphereUser user, Object[] authInfo) {
        String h3HexString = (String)authInfo[0];
        String salt = (String)authInfo[1];
        String nonce = (String)authInfo[2];
        int serverIteration = (Integer)authInfo[3];
        byte[] serverStoredKey = OpenGaussMacCalculator.requestClientMac((String)user.getPassword(), (String)salt, (int)serverIteration);
        byte[] clientCalculatedStoredKey = OpenGaussMacCalculator.calculateClientMac((String)h3HexString, (String)nonce, (byte[])serverStoredKey);
        return Arrays.equals(clientCalculatedStoredKey, serverStoredKey);
    }

    public String getAuthenticationMethodName() {
        return OpenGaussAuthenticationMethod.SCRAM_SHA256.getMethodName();
    }
}

