/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.state;

import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.driver.state.DriverState;
import org.apache.shardingsphere.driver.state.circuit.CircuitBreakDriverState;
import org.apache.shardingsphere.driver.state.ok.OKDriverState;
import org.apache.shardingsphere.infra.state.instance.InstanceState;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class DriverStateContext {
    private static final Map<InstanceState, DriverState> STATES = new ConcurrentHashMap<InstanceState, DriverState>(2, 1.0f);

    public static Connection getConnection(String databaseName, ContextManager contextManager) {
        return STATES.get(contextManager.getComputeNodeInstanceContext().getInstance().getState().getCurrentState()).getConnection(databaseName, contextManager);
    }

    @Generated
    private DriverStateContext() {
    }

    static {
        STATES.put(InstanceState.OK, new OKDriverState());
        STATES.put(InstanceState.CIRCUIT_BREAK, new CircuitBreakDriverState());
    }
}

