/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessRegistry;
import org.apache.shardingsphere.infra.executor.sql.process.lock.ProcessOperationLockRegistry;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.node.path.metadata.ComputeNodePath;

public final class KillProcessHandler
implements DataChangedEventHandler {
    @Override
    public String getSubscribedKey() {
        return ComputeNodePath.getKillProcessTriggerRootPath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        Matcher matcher = this.getKillProcessTriggerMatcher(event);
        if (!matcher.find()) {
            return;
        }
        String instanceId = matcher.group(1);
        String processId = matcher.group(2);
        if (DataChangedEvent.Type.ADDED == event.getType()) {
            if (!instanceId.equals(contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId())) {
                return;
            }
            try {
                ProcessRegistry.getInstance().kill(processId);
            }
            catch (SQLException ex) {
                throw new SQLWrapperException(ex);
            }
            contextManager.getPersistCoordinatorFacade().getProcessPersistCoordinator().cleanProcess(instanceId, processId);
        } else if (DataChangedEvent.Type.DELETED == event.getType()) {
            ProcessOperationLockRegistry.getInstance().notify(processId);
        }
    }

    private Matcher getKillProcessTriggerMatcher(DataChangedEvent event) {
        return Pattern.compile(ComputeNodePath.getKillProcessTriggerRootPath() + "/([\\S]+):([\\S]+)$", 2).matcher(event.getKey());
    }
}

