/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.retriever.dml.table.column;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.condition.ShadowCondition;
import org.apache.shardingsphere.shadow.route.determiner.ColumnShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.route.retriever.dml.table.ShadowTableDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;
import org.apache.shardingsphere.shadow.spi.column.ColumnShadowAlgorithm;

public abstract class ShadowColumnDataSourceMappingsRetriever
implements ShadowTableDataSourceMappingsRetriever {
    private final ShadowOperationType operationType;

    @Override
    public Map<String, String> retrieve(ShadowRule rule, Collection<String> shadowTables) {
        for (String each : shadowTables) {
            Collection<String> shadowColumnNames = rule.getShadowColumnNames(this.operationType, each);
            if (shadowColumnNames.isEmpty() || !this.isMatchAnyColumnShadowAlgorithms(rule, each, shadowColumnNames)) continue;
            return rule.getShadowDataSourceMappings(each);
        }
        return Collections.emptyMap();
    }

    private boolean isMatchAnyColumnShadowAlgorithms(ShadowRule rule, String shadowTable, Collection<String> shadowColumnNames) {
        for (String each : shadowColumnNames) {
            if (!this.isMatchAnyColumnShadowAlgorithms(rule, shadowTable, each)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchAnyColumnShadowAlgorithms(ShadowRule rule, String shadowTable, String shadowColumn) {
        Collection<ColumnShadowAlgorithm<Comparable<?>>> columnShadowAlgorithms = rule.getColumnShadowAlgorithms(this.operationType, shadowTable, shadowColumn);
        if (columnShadowAlgorithms.isEmpty()) {
            return false;
        }
        for (ShadowColumnCondition each : this.getShadowColumnConditions(shadowColumn)) {
            if (!this.isMatchColumnShadowAlgorithm(shadowTable, columnShadowAlgorithms, each)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchColumnShadowAlgorithm(String shadowTable, Collection<ColumnShadowAlgorithm<Comparable<?>>> algorithms, ShadowColumnCondition condition) {
        for (ColumnShadowAlgorithm<Comparable<?>> each : algorithms) {
            if (!ColumnShadowAlgorithmDeterminer.isShadow(each, new ShadowCondition(shadowTable, this.operationType, condition))) continue;
            return true;
        }
        return false;
    }

    protected abstract Collection<ShadowColumnCondition> getShadowColumnConditions(String var1);

    @Generated
    public ShadowColumnDataSourceMappingsRetriever(ShadowOperationType operationType) {
        this.operationType = operationType;
    }
}

