/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.rule;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.spi.PrivilegeProvider;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class AuthorityRule
implements GlobalRule {
    private final AuthorityRuleConfiguration configuration;
    private final Map<ShardingSphereUser, ShardingSpherePrivileges> privileges;

    public AuthorityRule(AuthorityRuleConfiguration ruleConfig) {
        this.configuration = ruleConfig;
        Collection users = ruleConfig.getUsers().stream().map(each -> new ShardingSphereUser(each.getUsername(), each.getPassword(), each.getHostname(), each.getAuthenticationMethodName(), each.isAdmin())).collect(Collectors.toList());
        this.privileges = users.stream().collect(Collectors.toMap(each -> each, each -> ((PrivilegeProvider)TypedSPILoader.getService(PrivilegeProvider.class, (Object)ruleConfig.getPrivilegeProvider().getType(), (Properties)ruleConfig.getPrivilegeProvider().getProps())).build(ruleConfig, each.getGrantee()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public String getAuthenticatorType(ShardingSphereUser user) {
        if (this.configuration.getAuthenticators().containsKey(user.getAuthenticationMethodName())) {
            return ((AlgorithmConfiguration)this.configuration.getAuthenticators().get(user.getAuthenticationMethodName())).getType();
        }
        if (this.configuration.getAuthenticators().containsKey(this.configuration.getDefaultAuthenticator())) {
            return ((AlgorithmConfiguration)this.configuration.getAuthenticators().get(this.configuration.getDefaultAuthenticator())).getType();
        }
        return "";
    }

    public Collection<Grantee> getGrantees() {
        return this.privileges.keySet().stream().map(ShardingSphereUser::getGrantee).collect(Collectors.toList());
    }

    public Optional<ShardingSphereUser> findUser(Grantee grantee) {
        for (ShardingSphereUser each : this.privileges.keySet()) {
            if (!each.getGrantee().accept(grantee)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public Optional<ShardingSpherePrivileges> findPrivileges(Grantee grantee) {
        for (ShardingSphereUser each : this.privileges.keySet()) {
            if (!each.getGrantee().accept(grantee)) continue;
            return Optional.of(each).map(this.privileges::get);
        }
        return Optional.empty();
    }

    public int getOrder() {
        return 500;
    }

    @Generated
    public AuthorityRuleConfiguration getConfiguration() {
        return this.configuration;
    }
}

