/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.sender.okhttp.internal;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.compression.Compressor;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.okhttp3.MediaType;
import org.apache.shardingsphere.shade.okhttp3.RequestBody;
import org.apache.shardingsphere.shade.okio.Buffer;
import org.apache.shardingsphere.shade.okio.BufferedSink;
import org.apache.shardingsphere.shade.okio.Okio;

public final class GrpcRequestBody
extends RequestBody {
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED_FLAG = 0;
    private static final byte COMPRESSED_FLAG = 1;
    private static final MediaType GRPC_MEDIA_TYPE = MediaType.parse("application/grpc");
    private final Marshaler marshaler;
    private final int messageSize;
    private final int contentLength;
    @Nullable
    private final Compressor compressor;

    public GrpcRequestBody(Marshaler marshaler, @Nullable Compressor compressor) {
        this.marshaler = marshaler;
        this.compressor = compressor;
        this.messageSize = marshaler.getBinarySerializedSize();
        this.contentLength = compressor != null ? -1 : 5 + this.messageSize;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return GRPC_MEDIA_TYPE;
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    public void writeTo(BufferedSink sink2) throws IOException {
        if (this.compressor == null) {
            sink2.writeByte(0);
            sink2.writeInt(this.messageSize);
            this.marshaler.writeBinaryTo(sink2.outputStream());
        } else {
            try (Buffer compressedBody = new Buffer();){
                try (BufferedSink compressedSink = Okio.buffer(Okio.sink(this.compressor.compress(compressedBody.outputStream())));){
                    this.marshaler.writeBinaryTo(compressedSink.outputStream());
                }
                sink2.writeByte(1);
                int compressedBytes = (int)compressedBody.size();
                sink2.writeInt(compressedBytes);
                sink2.write(compressedBody, (long)compressedBytes);
            }
        }
    }
}

