/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.statement.ral.updatable.RefreshDatabaseMetaDataStatement;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SystemSchemaUtils;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class RefreshDatabaseMetaDataExecutor
implements DistSQLUpdateExecutor<RefreshDatabaseMetaDataStatement> {
    public void executeUpdate(RefreshDatabaseMetaDataStatement sqlStatement, ContextManager contextManager) throws SQLException {
        Map databases = sqlStatement.getDatabaseName().map(optional -> Collections.singletonMap(optional, contextManager.getDatabase(optional))).orElseGet(() -> contextManager.getMetaDataContexts().getMetaData().getDatabases());
        for (ShardingSphereDatabase each : databases.values()) {
            if (SystemSchemaUtils.isSystemSchema((ShardingSphereDatabase)each)) continue;
            if (sqlStatement.isForce()) {
                contextManager.getMetaDataContextManager().forceRefreshDatabaseMetaData(each);
                continue;
            }
            contextManager.getMetaDataContextManager().refreshTableMetaData(each);
        }
    }

    public Class<RefreshDatabaseMetaDataStatement> getType() {
        return RefreshDatabaseMetaDataStatement.class;
    }
}

