/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.data.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.EmptyStorageUnitException;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnector;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnectorFactory;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class UnicastDatabaseBackendHandler
implements DatabaseBackendHandler {
    private final DatabaseConnectorFactory databaseConnectorFactory = DatabaseConnectorFactory.getInstance();
    private final QueryContext queryContext;
    private final ConnectionSession connectionSession;
    private DatabaseConnector databaseConnector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseHeader execute() throws SQLException {
        String originalDatabaseName = this.connectionSession.getCurrentDatabaseName();
        String unicastDatabaseName = null == originalDatabaseName ? this.getFirstDatabaseName() : originalDatabaseName;
        ShardingSpherePreconditions.checkState((boolean)ProxyContext.getInstance().getContextManager().getDatabase(unicastDatabaseName).containsDataSource(), () -> new EmptyStorageUnitException(unicastDatabaseName));
        try {
            this.connectionSession.setCurrentDatabaseName(unicastDatabaseName);
            this.databaseConnector = this.databaseConnectorFactory.newInstance(this.queryContext, this.connectionSession.getDatabaseConnectionManager(), false);
            ResponseHeader responseHeader = this.databaseConnector.execute();
            return responseHeader;
        }
        finally {
            this.connectionSession.setCurrentDatabaseName(originalDatabaseName);
        }
    }

    private String getFirstDatabaseName() {
        Collection<String> databaseNames = ProxyContext.getInstance().getAllDatabaseNames();
        if (databaseNames.isEmpty()) {
            throw new NoDatabaseSelectedException();
        }
        AuthorityRule authorityRule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        Optional privileges = authorityRule.findPrivileges(this.connectionSession.getConnectionContext().getGrantee());
        Stream<String> databaseStream = databaseNames.stream().filter(each -> ProxyContext.getInstance().getContextManager().getDatabase(each).containsDataSource());
        Optional result = privileges.map(optional -> databaseStream.filter(arg_0 -> ((ShardingSpherePrivileges)optional).hasPrivileges(arg_0)).findFirst()).orElseGet(databaseStream::findFirst);
        ShardingSpherePreconditions.checkState((boolean)result.isPresent(), EmptyStorageUnitException::new);
        return (String)result.get();
    }

    @Override
    public boolean next() throws SQLException {
        return this.databaseConnector.next();
    }

    @Override
    public QueryResponseRow getRowData() throws SQLException {
        return this.databaseConnector.getRowData();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.databaseConnector) {
            this.databaseConnector.close();
        }
    }

    @Generated
    public UnicastDatabaseBackendHandler(QueryContext queryContext, ConnectionSession connectionSession) {
        this.queryContext = queryContext;
        this.connectionSession = connectionSession;
    }
}

