/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public abstract class AbstractDatabaseMetaDataExecutor
implements DatabaseAdminQueryExecutor {
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;
    private final List<Map<String, Object>> rows = new LinkedList<Map<String, Object>>();
    private final Collection<String> labels = new LinkedList<String>();

    @Override
    public final void execute(ConnectionSession connectionSession) throws SQLException {
        Collection<String> databaseNames = this.getDatabaseNames(connectionSession);
        for (String databaseName : databaseNames) {
            this.processMetaData(databaseName, resultSet -> this.handleResultSet(databaseName, (ResultSet)resultSet));
        }
        this.postProcess();
        this.queryResultMetaData = this.createQueryResultMetaData();
        this.mergedResult = this.createMergedResult();
    }

    private void handleResultSet(String databaseName, ResultSet resultSet) {
        ResultSetMetaData metaData = resultSet.getMetaData();
        while (resultSet.next()) {
            int columnCount = metaData.getColumnCount();
            LinkedHashMap<String, Object> rowMap = new LinkedHashMap<String, Object>(columnCount, 1.0f);
            LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>(columnCount, 1.0f);
            for (int i = 1; i < columnCount + 1; ++i) {
                aliasMap.put(metaData.getColumnName(i), metaData.getColumnLabel(i));
                rowMap.put(metaData.getColumnLabel(i), resultSet.getString(i));
            }
            this.preProcess(databaseName, rowMap, aliasMap);
            if (rowMap.isEmpty()) continue;
            this.rows.add(rowMap);
        }
        if (this.rows.isEmpty()) {
            for (int i = 1; i < metaData.getColumnCount() + 1; ++i) {
                this.labels.add(metaData.getColumnLabel(i));
            }
        }
    }

    protected abstract Collection<String> getDatabaseNames(ConnectionSession var1);

    protected abstract void preProcess(String var1, Map<String, Object> var2, Map<String, String> var3) throws SQLException;

    protected abstract void postProcess();

    protected abstract void processMetaData(String var1, Consumer<ResultSet> var2) throws SQLException;

    private MergedResult createMergedResult() {
        List resultDataRows = this.rows.stream().map(each -> new MemoryQueryResultDataRow(new LinkedList(each.values()))).collect(Collectors.toList());
        return new TransparentMergedResult((QueryResult)new RawMemoryQueryResult(this.queryResultMetaData, resultDataRows));
    }

    private RawQueryResultMetaData createQueryResultMetaData() {
        if (this.rows.isEmpty() && !this.labels.isEmpty()) {
            List columns = this.labels.stream().map(each -> new RawQueryResultColumnMetaData("", each, each, 12, "VARCHAR", 20, 0)).collect(Collectors.toList());
            return new RawQueryResultMetaData(columns);
        }
        List columns = this.rows.stream().flatMap(each -> each.keySet().stream()).collect(Collectors.toCollection(LinkedHashSet::new)).stream().map(each -> new RawQueryResultColumnMetaData("", each, each, 12, "VARCHAR", 20, 0)).collect(Collectors.toList());
        return new RawQueryResultMetaData(columns);
    }

    protected static Boolean hasDataSource(String databaseName) {
        return ProxyContext.getInstance().getContextManager().getDatabase(databaseName).containsDataSource();
    }

    protected static boolean isAuthorized(String databaseName, Grantee grantee) {
        AuthorityRule authorityRule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        return new AuthorityChecker(authorityRule, grantee).isAuthorized(databaseName);
    }

    @Override
    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }

    @Generated
    public List<Map<String, Object>> getRows() {
        return this.rows;
    }

    @Generated
    public Collection<String> getLabels() {
        return this.labels;
    }

    public static class DefaultDatabaseMetaDataExecutor
    extends AbstractDatabaseMetaDataExecutor {
        private final String sql;
        private final List<Object> parameters;

        @Override
        protected Collection<String> getDatabaseNames(ConnectionSession connectionSession) {
            Optional<String> database = ProxyContext.getInstance().getAllDatabaseNames().stream().filter(each -> DefaultDatabaseMetaDataExecutor.isAuthorized(each, connectionSession.getConnectionContext().getGrantee())).filter(AbstractDatabaseMetaDataExecutor::hasDataSource).findFirst();
            return database.map(Collections::singletonList).orElse(Collections.emptyList());
        }

        @Override
        protected void processMetaData(String databaseName, Consumer<ResultSet> callback) throws SQLException {
            ResourceMetaData resourceMetaData = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getResourceMetaData();
            Optional storageUnit = resourceMetaData.getStorageUnits().values().stream().findFirst();
            if (!storageUnit.isPresent()) {
                return;
            }
            try (Connection connection = ((StorageUnit)storageUnit.get()).getDataSource().getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(this.sql);){
                for (int i = 0; i < this.parameters.size(); ++i) {
                    preparedStatement.setObject(i + 1, this.parameters.get(i));
                }
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    callback.accept(resultSet);
                }
            }
        }

        @Override
        protected void preProcess(String databaseName, Map<String, Object> rows, Map<String, String> alias) throws SQLException {
        }

        @Override
        protected void postProcess() {
        }

        @Generated
        public DefaultDatabaseMetaDataExecutor(String sql, List<Object> parameters) {
            this.sql = sql;
            this.parameters = parameters;
        }
    }
}

