/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin.internal;

import java.time.Duration;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanExporter;

public class ZipkinSpanExporterProvider
implements ConfigurableSpanExporterProvider {
    @Override
    public String getName() {
        return "zipkin";
    }

    @Override
    public SpanExporter createExporter(ConfigProperties config) {
        Duration timeout2;
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.zipkin.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout2 = config.getDuration("otel.exporter.zipkin.timeout")) != null) {
            builder.setReadTimeout(timeout2);
        }
        return builder.build();
    }
}

