/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp;

import java.io.IOException;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.common.v1.internal.AnyValue;

final class BoolAnyValueMarshaler
extends MarshalerWithSize {
    private final boolean value;

    private BoolAnyValueMarshaler(boolean value) {
        super(BoolAnyValueMarshaler.calculateSize(value));
        this.value = value;
    }

    static MarshalerWithSize create(boolean value) {
        return new BoolAnyValueMarshaler(value);
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeBool(AnyValue.BOOL_VALUE, this.value);
    }

    private static int calculateSize(boolean value) {
        return AnyValue.BOOL_VALUE.getTagSize() + CodedOutputStream.computeBoolSizeNoTag(value);
    }
}

