/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.constant;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;

public enum MySQLBinaryColumnType implements BinaryColumnType
{
    DECIMAL(0),
    TINY(1),
    SHORT(2),
    LONG(3),
    FLOAT(4),
    DOUBLE(5),
    NULL(6),
    TIMESTAMP(7),
    LONGLONG(8),
    INT24(9),
    DATE(10),
    TIME(11),
    DATETIME(12),
    YEAR(13),
    NEWDATE(14),
    VARCHAR(15),
    BIT(16),
    TIMESTAMP2(17),
    DATETIME2(18),
    TIME2(19),
    JSON(245),
    NEWDECIMAL(246),
    ENUM(247),
    SET(248),
    TINY_BLOB(249),
    MEDIUM_BLOB(250),
    LONG_BLOB(251),
    BLOB(252),
    VAR_STRING(253),
    STRING(254),
    GEOMETRY(255);

    private static final Map<Integer, MySQLBinaryColumnType> JDBC_TYPE_AND_COLUMN_TYPE_MAP;
    private static final Map<Integer, MySQLBinaryColumnType> VALUE_AND_COLUMN_TYPE_MAP;
    private final int value;

    public static MySQLBinaryColumnType valueOfJDBCType(int jdbcType) {
        Preconditions.checkArgument((boolean)JDBC_TYPE_AND_COLUMN_TYPE_MAP.containsKey(jdbcType), (String)"Can not find JDBC type `%s` in column type", (int)jdbcType);
        return JDBC_TYPE_AND_COLUMN_TYPE_MAP.get(jdbcType);
    }

    public static MySQLBinaryColumnType valueOf(int value) {
        Preconditions.checkArgument((boolean)VALUE_AND_COLUMN_TYPE_MAP.containsKey(value), (String)"Can not find value `%s` in column type", (int)value);
        return VALUE_AND_COLUMN_TYPE_MAP.get(value);
    }

    @Generated
    private MySQLBinaryColumnType(int value) {
        this.value = value;
    }

    @Generated
    public int getValue() {
        return this.value;
    }

    static {
        JDBC_TYPE_AND_COLUMN_TYPE_MAP = new HashMap<Integer, MySQLBinaryColumnType>(MySQLBinaryColumnType.values().length, 1.0f);
        VALUE_AND_COLUMN_TYPE_MAP = new HashMap<Integer, MySQLBinaryColumnType>(MySQLBinaryColumnType.values().length, 1.0f);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-7, BIT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-6, TINY);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(5, SHORT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(4, LONG);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-5, LONGLONG);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(6, FLOAT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(7, FLOAT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(8, DOUBLE);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2, NEWDECIMAL);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(3, NEWDECIMAL);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(1, STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(12, VAR_STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-1, VAR_STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(91, DATE);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(92, TIME);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(93, TIMESTAMP);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-2, STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-3, VAR_STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-4, VAR_STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(0, NULL);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2004, BLOB);
        for (MySQLBinaryColumnType each : MySQLBinaryColumnType.values()) {
            VALUE_AND_COLUMN_TYPE_MAP.put(each.value, each);
        }
    }
}

