/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.inventory;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.column.DialectInventoryColumnValueReader;

public final class MySQLInventoryColumnValueReader
implements DialectInventoryColumnValueReader {
    private static final String YEAR_DATA_TYPE = "YEAR";

    public Optional<Object> read(ResultSet resultSet, ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return this.isYearDataType(metaData.getColumnTypeName(columnIndex)) ? Optional.of(resultSet.getShort(columnIndex)) : Optional.empty();
    }

    private boolean isYearDataType(String columnDataTypeName) {
        return YEAR_DATA_TYPE.equalsIgnoreCase(columnDataTypeName);
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

