/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.protocol;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class FrontDatabaseProtocolTypeFactory {
    private static final String DEFAULT_FRONTEND_DATABASE_PROTOCOL_TYPE = "MySQL";

    public static DatabaseType getDatabaseType() {
        Optional<DatabaseType> configuredDatabaseType = FrontDatabaseProtocolTypeFactory.findConfiguredDatabaseType();
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        if (metaDataContexts.getMetaData().getDatabases().isEmpty()) {
            return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)DEFAULT_FRONTEND_DATABASE_PROTOCOL_TYPE);
        }
        Optional<ShardingSphereDatabase> database = metaDataContexts.getMetaData().getDatabases().values().stream().filter(ShardingSphereDatabase::containsDataSource).findFirst();
        return database.isPresent() ? ((StorageUnit)database.get().getResourceMetaData().getStorageUnits().values().iterator().next()).getStorageType() : (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)DEFAULT_FRONTEND_DATABASE_PROTOCOL_TYPE);
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType() {
        DatabaseType configuredDatabaseType = (DatabaseType)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return null == configuredDatabaseType ? Optional.empty() : Optional.of(configuredDatabaseType.getTrunkDatabaseType().orElse(configuredDatabaseType));
    }

    @Generated
    private FrontDatabaseProtocolTypeFactory() {
    }
}

