/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.distsql.handler.provider;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.AlgorithmDistSQLConverter;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskColumnRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;

public final class MaskRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<MaskRuleConfiguration> {
    private static final String CREATE_MASK = "CREATE MASK RULE";
    private static final String MASK = " %s (" + System.lineSeparator() + "COLUMNS(" + System.lineSeparator() + "%s" + System.lineSeparator() + "),";
    private static final String MASK_COLUMN = "(NAME=%s, %s)";

    public String convert(MaskRuleConfiguration ruleConfig) {
        if (ruleConfig.getTables().isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(CREATE_MASK);
        Iterator iterator = ruleConfig.getTables().iterator();
        while (iterator.hasNext()) {
            MaskTableRuleConfiguration tableRuleConfig = (MaskTableRuleConfiguration)iterator.next();
            result.append(String.format(MASK, tableRuleConfig.getName(), this.getMaskColumns(tableRuleConfig.getColumns(), ruleConfig.getMaskAlgorithms())));
            if (!iterator.hasNext()) continue;
            result.append(",").append(System.lineSeparator());
        }
        result.append(";");
        return result.toString();
    }

    private String getMaskColumns(Collection<MaskColumnRuleConfiguration> columnRuleConfig, Map<String, AlgorithmConfiguration> maskAlgorithms) {
        StringBuilder result = new StringBuilder();
        Iterator<MaskColumnRuleConfiguration> iterator = columnRuleConfig.iterator();
        if (iterator.hasNext()) {
            MaskColumnRuleConfiguration column = iterator.next();
            result.append(String.format(MASK_COLUMN, column.getLogicColumn(), this.getMaskAlgorithms(column, maskAlgorithms)));
        }
        return result.toString();
    }

    private String getMaskAlgorithms(MaskColumnRuleConfiguration columnRuleConfig, Map<String, AlgorithmConfiguration> maskAlgorithms) {
        return AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)maskAlgorithms.get(columnRuleConfig.getMaskAlgorithm()));
    }

    public Class<MaskRuleConfiguration> getType() {
        return MaskRuleConfiguration.class;
    }
}

