/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.StreamDataRequestBody;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.system.DialectSystemDatabase;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.SchemaNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.TableNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;

public final class CDCSchemaTableUtils {
    public static Map<String, Set<String>> parseTableExpressionWithSchema(ShardingSphereDatabase database, Collection<StreamDataRequestBody.SchemaTable> schemaTables) {
        Collection systemSchemas = ((DialectSystemDatabase)DatabaseTypedSPILoader.getService(DialectSystemDatabase.class, (DatabaseType)database.getProtocolType())).getSystemSchemas();
        if (schemaTables.stream().anyMatch(each -> "*".equals(each.getTable()) && ("*".equals(each.getSchema()) || each.getSchema().isEmpty()))) {
            return CDCSchemaTableUtils.parseTableExpressionWithAllTables(database, systemSchemas);
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(database.getProtocolType()).getDialectDatabaseMetaData();
        for (StreamDataRequestBody.SchemaTable each2 : schemaTables) {
            if ("*".equals(each2.getSchema())) {
                result.putAll(CDCSchemaTableUtils.parseTableExpressionWithAllSchema(database, systemSchemas, each2));
                continue;
            }
            if ("*".equals(each2.getTable())) {
                result.putAll(CDCSchemaTableUtils.parseTableExpressionWithAllTable(database, each2));
                continue;
            }
            String schemaName = each2.getSchema();
            if (dialectDatabaseMetaData.getDefaultSchema().isPresent() && schemaName.isEmpty()) {
                schemaName = (String)dialectDatabaseMetaData.getDefaultSchema().get();
            }
            ShardingSpherePreconditions.checkNotNull((Object)database.getSchema(schemaName).getTable(each2.getTable()), () -> new TableNotFoundException(each2.getTable()));
            result.computeIfAbsent(schemaName, ignored -> new HashSet()).add(each2.getTable());
        }
        return result;
    }

    private static Map<String, Set<String>> parseTableExpressionWithAllTables(ShardingSphereDatabase database, Collection<String> systemSchemas) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(database.getSchemas().size(), 1.0f);
        for (Map.Entry entry : database.getSchemas().entrySet()) {
            if (systemSchemas.contains(entry.getKey())) continue;
            ((ShardingSphereSchema)entry.getValue()).getAllTableNames().forEach(tableName -> result.computeIfAbsent((String)entry.getKey(), ignored -> new HashSet()).add(tableName));
        }
        return result;
    }

    private static Map<String, Set<String>> parseTableExpressionWithAllSchema(ShardingSphereDatabase database, Collection<String> systemSchemas, StreamDataRequestBody.SchemaTable table) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(database.getSchemas().size(), 1.0f);
        for (Map.Entry entry : database.getSchemas().entrySet()) {
            if (systemSchemas.contains(entry.getKey())) continue;
            ((ShardingSphereSchema)entry.getValue()).getAllTableNames().stream().filter(tableName -> tableName.equals(table.getTable())).findFirst().ifPresent(optional -> result.computeIfAbsent((String)entry.getKey(), ignored -> new HashSet()).add(optional));
        }
        return result;
    }

    private static Map<String, Set<String>> parseTableExpressionWithAllTable(ShardingSphereDatabase database, StreamDataRequestBody.SchemaTable each) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(database.getProtocolType()).getDialectDatabaseMetaData();
        String schemaName = each.getSchema().isEmpty() ? (String)dialectDatabaseMetaData.getDefaultSchema().orElseThrow(() -> new IllegalStateException("Default schema should exist.")) : each.getSchema();
        ShardingSphereSchema schema = database.getSchema(schemaName);
        ShardingSpherePreconditions.checkNotNull((Object)schema, () -> new SchemaNotFoundException(each.getSchema()));
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(schema.getAllTableNames().size(), 1.0f);
        schema.getAllTableNames().forEach(tableName -> result.computeIfAbsent(schemaName, ignored -> new HashSet()).add(tableName));
        return result;
    }

    public static Collection<String> parseTableExpressionWithoutSchema(ShardingSphereDatabase database, List<String> tableNames) {
        ShardingSphereSchema schema = database.getSchema(database.getName());
        HashSet<String> allTableNames = null == schema ? Collections.emptySet() : new HashSet<String>(schema.getAllTableNames());
        return tableNames.stream().anyMatch("*"::equals) ? allTableNames : new HashSet<String>(tableNames);
    }

    @Generated
    private CDCSchemaTableUtils() {
    }
}

