/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.metadata.persist.MetaDataPersistService;

public final class InternalMetaDataFactory {
    public static ShardingSphereDatabase create(String databaseName, MetaDataPersistService persistService, DatabaseConfiguration databaseConfig, ConfigurationProperties props, ComputeNodeInstanceContext computeNodeInstanceContext) {
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType((DatabaseConfiguration)databaseConfig, (ConfigurationProperties)props);
        return ShardingSphereDatabase.create((String)databaseName, (DatabaseType)protocolType, (DatabaseConfiguration)databaseConfig, (ComputeNodeInstanceContext)computeNodeInstanceContext, persistService.getDatabaseMetaDataFacade().getSchema().load(databaseName));
    }

    public static Map<String, ShardingSphereDatabase> create(MetaDataPersistService persistService, Map<String, DatabaseConfiguration> databaseConfigMap, ConfigurationProperties props, ComputeNodeInstanceContext computeNodeInstanceContext) {
        return InternalMetaDataFactory.createDatabases(persistService, databaseConfigMap, DatabaseTypeEngine.getProtocolType(databaseConfigMap, (ConfigurationProperties)props), props, computeNodeInstanceContext);
    }

    private static Map<String, ShardingSphereDatabase> createDatabases(MetaDataPersistService persistService, Map<String, DatabaseConfiguration> databaseConfigMap, DatabaseType protocolType, ConfigurationProperties props, ComputeNodeInstanceContext computeNodeInstanceContext) {
        ConcurrentHashMap<String, ShardingSphereDatabase> result = new ConcurrentHashMap<String, ShardingSphereDatabase>(databaseConfigMap.size(), 1.0f);
        for (Map.Entry<String, DatabaseConfiguration> entry : databaseConfigMap.entrySet()) {
            String databaseName = entry.getKey();
            result.put(databaseName.toLowerCase(), entry.getValue().getStorageUnits().isEmpty() ? ShardingSphereDatabase.create((String)databaseName, (DatabaseType)protocolType, (ConfigurationProperties)props) : InternalMetaDataFactory.create(databaseName, persistService, entry.getValue(), props, computeNodeInstanceContext));
        }
        return result;
    }

    @Generated
    private InternalMetaDataFactory() {
    }
}

