/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.admin.MySQLComResetConnectionPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.admin.MySQLComSetOptionPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.admin.MySQLUnsupportedCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.admin.initdb.MySQLComInitDbPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.admin.ping.MySQLComPingPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.admin.quit.MySQLComQuitPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLComStmtSendLongDataPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.close.MySQLComStmtClosePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLComStmtExecutePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.prepare.MySQLComStmtPreparePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.reset.MySQLComStmtResetPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.fieldlist.MySQLComFieldListPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.query.MySQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.MySQLServerPreparedStatement;

public final class MySQLCommandPacketFactory {
    public static MySQLCommandPacket newInstance(MySQLCommandPacketType commandPacketType, MySQLPacketPayload payload, ConnectionSession connectionSession) {
        switch (commandPacketType) {
            case COM_QUIT: {
                return new MySQLComQuitPacket();
            }
            case COM_INIT_DB: {
                return new MySQLComInitDbPacket(payload);
            }
            case COM_FIELD_LIST: {
                return new MySQLComFieldListPacket(payload);
            }
            case COM_QUERY: {
                return new MySQLComQueryPacket(payload);
            }
            case COM_STMT_PREPARE: {
                return new MySQLComStmtPreparePacket(payload);
            }
            case COM_STMT_EXECUTE: {
                MySQLServerPreparedStatement serverPreparedStatement = (MySQLServerPreparedStatement)connectionSession.getServerPreparedStatementRegistry().getPreparedStatement((Object)payload.getByteBuf().getIntLE(payload.getByteBuf().readerIndex()));
                return new MySQLComStmtExecutePacket(payload, serverPreparedStatement.getSqlStatementContext().getSqlStatement().getParameterCount());
            }
            case COM_STMT_SEND_LONG_DATA: {
                return new MySQLComStmtSendLongDataPacket(payload);
            }
            case COM_STMT_RESET: {
                return new MySQLComStmtResetPacket(payload);
            }
            case COM_STMT_CLOSE: {
                return new MySQLComStmtClosePacket(payload);
            }
            case COM_SET_OPTION: {
                return new MySQLComSetOptionPacket(payload);
            }
            case COM_PING: {
                return new MySQLComPingPacket();
            }
            case COM_RESET_CONNECTION: {
                return new MySQLComResetConnectionPacket();
            }
        }
        return new MySQLUnsupportedCommandPacket(commandPacketType);
    }

    @Generated
    private MySQLCommandPacketFactory() {
    }
}

