/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.type;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.DeleteStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.InsertStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.SelectStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.UpdateStatementBinder;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class DMLStatementBindEngine {
    private final ShardingSphereMetaData metaData;
    private final String currentDatabaseName;

    public DMLStatement bind(DMLStatement statement) {
        SQLStatementBinderContext binderContext = new SQLStatementBinderContext((SQLStatement)statement, this.metaData, this.currentDatabaseName);
        if (statement instanceof SelectStatement) {
            return new SelectStatementBinder().bind((SelectStatement)statement, binderContext);
        }
        if (statement instanceof InsertStatement) {
            return new InsertStatementBinder().bind((InsertStatement)statement, binderContext);
        }
        if (statement instanceof UpdateStatement) {
            return new UpdateStatementBinder().bind((UpdateStatement)statement, binderContext);
        }
        if (statement instanceof DeleteStatement) {
            return new DeleteStatementBinder().bind((DeleteStatement)statement, binderContext);
        }
        return statement;
    }

    @Generated
    public DMLStatementBindEngine(ShardingSphereMetaData metaData, String currentDatabaseName) {
        this.metaData = metaData;
        this.currentDatabaseName = currentDatabaseName;
    }
}

