/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.dml;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.engine.segment.column.InsertColumnsSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.expression.type.SubquerySegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;

public final class InsertStatementBinder
implements SQLStatementBinder<InsertStatement> {
    @Override
    public InsertStatement bind(InsertStatement sqlStatement, SQLStatementBinderContext binderContext) {
        InsertStatement result = this.copy(sqlStatement);
        LinkedHashMap<String, TableSegmentBinderContext> tableBinderContexts = new LinkedHashMap<String, TableSegmentBinderContext>();
        sqlStatement.getTable().ifPresent(optional -> result.setTable(SimpleTableSegmentBinder.bind(optional, binderContext, tableBinderContexts)));
        if (sqlStatement.getInsertColumns().isPresent() && !((InsertColumnsSegment)sqlStatement.getInsertColumns().get()).getColumns().isEmpty()) {
            result.setInsertColumns(InsertColumnsSegmentBinder.bind((InsertColumnsSegment)sqlStatement.getInsertColumns().get(), binderContext, tableBinderContexts));
        } else {
            sqlStatement.getInsertColumns().ifPresent(arg_0 -> ((InsertStatement)result).setInsertColumns(arg_0));
            tableBinderContexts.values().forEach(each -> result.getDerivedInsertColumns().addAll(this.getVisibleColumns(each.getProjectionSegments())));
        }
        sqlStatement.getInsertSelect().ifPresent(optional -> result.setInsertSelect(SubquerySegmentBinder.bind(optional, binderContext, tableBinderContexts)));
        return result;
    }

    private InsertStatement copy(InsertStatement sqlStatement) {
        InsertStatement result = (InsertStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        result.getValues().addAll(sqlStatement.getValues());
        sqlStatement.getSetAssignment().ifPresent(arg_0 -> ((InsertStatement)result).setSetAssignment(arg_0));
        sqlStatement.getOnDuplicateKeyColumns().ifPresent(arg_0 -> ((InsertStatement)result).setOnDuplicateKeyColumns(arg_0));
        sqlStatement.getWithSegment().ifPresent(arg_0 -> ((InsertStatement)result).setWithSegment(arg_0));
        sqlStatement.getOutputSegment().ifPresent(arg_0 -> ((InsertStatement)result).setOutputSegment(arg_0));
        sqlStatement.getMultiTableInsertType().ifPresent(arg_0 -> ((InsertStatement)result).setMultiTableInsertType(arg_0));
        sqlStatement.getMultiTableInsertIntoSegment().ifPresent(arg_0 -> ((InsertStatement)result).setMultiTableInsertIntoSegment(arg_0));
        sqlStatement.getMultiTableConditionalIntoSegment().ifPresent(arg_0 -> ((InsertStatement)result).setMultiTableConditionalIntoSegment(arg_0));
        sqlStatement.getReturningSegment().ifPresent(arg_0 -> ((InsertStatement)result).setReturningSegment(arg_0));
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        return result;
    }

    private Collection<ColumnSegment> getVisibleColumns(Collection<ProjectionSegment> projectionSegments) {
        return projectionSegments.stream().filter(each -> each instanceof ColumnProjectionSegment && each.isVisible()).map(each -> ((ColumnProjectionSegment)each).getColumn()).collect(Collectors.toList());
    }
}

