/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.opengauss.packet.authentication;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.opengauss.packet.authentication.OpenGaussAuthenticationHexData;

public final class OpenGaussMacCalculator {
    private static final String MAC_REQUEST_ALGORITHM = "HmacSHA256";
    private static final String SECRET_KEY_REQUEST_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String SHA256_ALGORITHM = "SHA-256";

    public static String requestServerMac(String password, OpenGaussAuthenticationHexData authHexData, int serverIteration) {
        byte[] serverKey = OpenGaussMacCalculator.getMacResult(OpenGaussMacCalculator.generateSecretKey(password, authHexData.getSalt(), serverIteration), MacType.SERVER.data.getBytes(StandardCharsets.UTF_8));
        byte[] result = OpenGaussMacCalculator.getMacResult(serverKey, OpenGaussMacCalculator.toHexBytes(authHexData.getNonce()));
        return OpenGaussMacCalculator.toHexString(result);
    }

    public static byte[] requestClientMac(String password, String salt, int serverIteration) {
        return OpenGaussMacCalculator.sha256(OpenGaussMacCalculator.getMacResult(OpenGaussMacCalculator.generateSecretKey(password, salt, serverIteration), MacType.CLIENT.data.getBytes()));
    }

    public static byte[] calculateClientMac(String h3HexString, String nonce, byte[] serverStoredKey) {
        byte[] h3 = OpenGaussMacCalculator.toHexBytes(h3HexString);
        byte[] h2 = OpenGaussMacCalculator.getMacResult(serverStoredKey, OpenGaussMacCalculator.toHexBytes(nonce));
        return OpenGaussMacCalculator.sha256(OpenGaussMacCalculator.xor(h3, h2));
    }

    private static byte[] getMacResult(byte[] key, byte[] data) {
        Mac mac = Mac.getInstance(MAC_REQUEST_ALGORITHM);
        mac.init(new SecretKeySpec(key, MAC_REQUEST_ALGORITHM));
        return mac.doFinal(data);
    }

    private static byte[] generateSecretKey(String password, String salt, int serverIteration) {
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), OpenGaussMacCalculator.toHexBytes(salt), serverIteration, 256);
        return SecretKeyFactory.getInstance(SECRET_KEY_REQUEST_ALGORITHM).generateSecret(keySpec).getEncoded();
    }

    private static byte[] toHexBytes(String hexString) {
        if (Strings.isNullOrEmpty((String)hexString)) {
            return new byte[0];
        }
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toUpperCase(Locale.ENGLISH).toCharArray();
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            result[i] = (byte)(OpenGaussMacCalculator.charToByte(hexChars[pos]) << 4 | OpenGaussMacCalculator.charToByte(hexChars[pos + 1]));
        }
        return result;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    private static String toHexString(byte[] hexBytes) {
        StringBuilder result = new StringBuilder();
        for (byte each : hexBytes) {
            String hex = Integer.toHexString(each & 0xFF);
            if (hex.length() < 2) {
                result.append(0);
            }
            result.append(hex);
        }
        return result.toString();
    }

    private static byte[] xor(byte[] password1, byte[] password2) {
        Preconditions.checkArgument((password1.length == password2.length ? 1 : 0) != 0, (Object)"Xor values with different length.");
        int length = password1.length;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)(password1[i] ^ password2[i]);
        }
        return result;
    }

    private static byte[] sha256(byte[] data) {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA256_ALGORITHM);
        messageDigest.update(data);
        return messageDigest.digest();
    }

    @Generated
    private OpenGaussMacCalculator() {
    }

    static enum MacType {
        SERVER("Server Key"),
        CLIENT("Client Key");

        private final String data;

        @Generated
        private MacType(String data) {
            this.data = data;
        }
    }
}

