/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.OrderByToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public final class ShardingOrderByTokenGenerator
implements OptionalSQLTokenGenerator<SelectStatementContext>,
IgnoreForSingleRoute {
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).getOrderByContext().isGenerated();
    }

    public OrderByToken generateSQLToken(SelectStatementContext selectStatementContext) {
        OrderByToken result = new OrderByToken(this.getGenerateOrderByStartIndex(selectStatementContext));
        for (OrderByItem each : selectStatementContext.getOrderByContext().getItems()) {
            String columnLabel;
            if (each.getSegment() instanceof ColumnOrderByItemSegment) {
                ColumnOrderByItemSegment columnOrderByItemSegment = (ColumnOrderByItemSegment)each.getSegment();
                columnLabel = columnOrderByItemSegment.getText();
            } else {
                columnLabel = each.getSegment() instanceof ExpressionOrderByItemSegment ? ((ExpressionOrderByItemSegment)each.getSegment()).getText() : String.valueOf(each.getIndex());
            }
            result.getColumnLabels().add(columnLabel);
            result.getOrderDirections().add(each.getSegment().getOrderDirection());
        }
        return result;
    }

    private int getGenerateOrderByStartIndex(SelectStatementContext selectStatementContext) {
        SelectStatement sqlStatement = selectStatementContext.getSqlStatement();
        int stopIndex = sqlStatement.getWindow().isPresent() ? ((WindowSegment)sqlStatement.getWindow().get()).getStopIndex() : (sqlStatement.getHaving().isPresent() ? ((HavingSegment)sqlStatement.getHaving().get()).getStopIndex() : (sqlStatement.getGroupBy().isPresent() ? ((GroupBySegment)sqlStatement.getGroupBy().get()).getStopIndex() : (sqlStatement.getWhere().isPresent() ? ((WhereSegment)sqlStatement.getWhere().get()).getStopIndex() : selectStatementContext.getTablesContext().getSimpleTables().stream().mapToInt(SimpleTableSegment::getStopIndex).max().orElse(0))));
        return stopIndex + 1;
    }
}

