/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.JobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.internal.annotation.JobAnnotationBuilder;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobScheduler;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class OneOffJobBootstrap
implements JobBootstrap {
    private final JobScheduler jobScheduler;
    private final InstanceService instanceService;

    public OneOffJobBootstrap(CoordinatorRegistryCenter regCenter, ElasticJob elasticJob, JobConfiguration jobConfig) {
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)jobConfig.getCron()), (Object)"Cron should be empty.");
        this.jobScheduler = new JobScheduler(regCenter, elasticJob, jobConfig);
        this.instanceService = new InstanceService(regCenter, jobConfig.getJobName());
    }

    public OneOffJobBootstrap(CoordinatorRegistryCenter regCenter, String elasticJobType, JobConfiguration jobConfig) {
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)jobConfig.getCron()), (Object)"Cron should be empty.");
        this.jobScheduler = new JobScheduler(regCenter, elasticJobType, jobConfig);
        this.instanceService = new InstanceService(regCenter, jobConfig.getJobName());
    }

    public OneOffJobBootstrap(CoordinatorRegistryCenter regCenter, ElasticJob elasticJob) {
        JobConfiguration jobConfig = JobAnnotationBuilder.generateJobConfiguration(elasticJob.getClass());
        this.jobScheduler = new JobScheduler(regCenter, elasticJob, jobConfig);
        this.instanceService = new InstanceService(regCenter, jobConfig.getJobName());
    }

    public void execute() {
        this.instanceService.triggerAllInstances();
    }

    @Override
    public void shutdown() {
        this.jobScheduler.shutdown();
    }
}

