/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql;

import java.util.Optional;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.dialect.DialectPipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment.PipelineSQLSegmentBuilder;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;

public final class PipelinePrepareSQLBuilder {
    private final DialectPipelineSQLBuilder dialectSQLBuilder;
    private final PipelineSQLSegmentBuilder sqlSegmentBuilder;

    public PipelinePrepareSQLBuilder(DatabaseType databaseType) {
        this.dialectSQLBuilder = (DialectPipelineSQLBuilder)DatabaseTypedSPILoader.getService(DialectPipelineSQLBuilder.class, (DatabaseType)databaseType);
        this.sqlSegmentBuilder = new PipelineSQLSegmentBuilder(databaseType);
    }

    public Optional<String> buildCreateSchemaSQL(String schemaName) {
        return this.dialectSQLBuilder.buildCreateSchemaSQL(this.sqlSegmentBuilder.getEscapedIdentifier(schemaName));
    }

    public String buildDropSQL(String schemaName, String tableName) {
        return String.format("DROP TABLE IF EXISTS %s", this.sqlSegmentBuilder.getQualifiedTableName(schemaName, tableName));
    }

    public String buildCountSQL(String schemaName, String tableName) {
        return String.format("SELECT COUNT(*) FROM %s", this.sqlSegmentBuilder.getQualifiedTableName(schemaName, tableName));
    }

    public Optional<String> buildEstimatedCountSQL(String schemaName, String tableName) {
        return this.dialectSQLBuilder.buildEstimatedCountSQL(this.sqlSegmentBuilder.getQualifiedTableName(schemaName, tableName));
    }

    public String buildUniqueKeyMinMaxValuesSQL(String schemaName, String tableName, String uniqueKey) {
        String escapedUniqueKey = this.sqlSegmentBuilder.getEscapedIdentifier(uniqueKey);
        return String.format("SELECT MIN(%s), MAX(%s) FROM %s", escapedUniqueKey, escapedUniqueKey, this.sqlSegmentBuilder.getQualifiedTableName(schemaName, tableName));
    }

    public String buildCheckEmptyTableSQL(String schemaName, String tableName) {
        return this.dialectSQLBuilder.buildCheckEmptyTableSQL(this.sqlSegmentBuilder.getQualifiedTableName(schemaName, tableName));
    }
}

