/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment;

import com.google.common.base.Strings;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;

public final class PipelineSQLSegmentBuilder {
    private final DialectDatabaseMetaData dialectDatabaseMetaData;

    public PipelineSQLSegmentBuilder(DatabaseType databaseType) {
        this.dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
    }

    public String getEscapedIdentifier(String identifier) {
        return this.dialectDatabaseMetaData.isReservedWord(identifier) ? this.dialectDatabaseMetaData.getQuoteCharacter().wrap(identifier) : identifier;
    }

    public String getQualifiedTableName(String schemaName, String tableName) {
        StringBuilder result = new StringBuilder();
        if (this.dialectDatabaseMetaData.isSchemaAvailable() && !Strings.isNullOrEmpty((String)schemaName)) {
            result.append(this.getEscapedIdentifier(schemaName)).append('.');
        }
        result.append(this.getEscapedIdentifier(tableName));
        return result.toString();
    }
}

