/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.lang3.Range;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.type.IntegerPrimaryKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.util.IntervalToRangeIterator;

public final class InventoryPositionCalculator {
    public static Collection<IngestPosition> getPositionByIntegerUniqueKeyRange(long tableRecordsCount, Range<Long> uniqueKeyValuesRange, long shardingSize) {
        if (0L == tableRecordsCount) {
            return Collections.singletonList(new IntegerPrimaryKeyIngestPosition(0L, 0L));
        }
        LinkedList<IngestPosition> result = new LinkedList<IngestPosition>();
        long splitCount = tableRecordsCount / shardingSize + (long)(tableRecordsCount % shardingSize > 0L ? 1 : 0);
        long interval = BigInteger.valueOf((Long)uniqueKeyValuesRange.getMaximum()).subtract(BigInteger.valueOf((Long)uniqueKeyValuesRange.getMinimum())).divide(BigInteger.valueOf(splitCount)).longValue();
        IntervalToRangeIterator rangeIterator = new IntervalToRangeIterator((Long)uniqueKeyValuesRange.getMinimum(), (Long)uniqueKeyValuesRange.getMaximum(), interval);
        while (rangeIterator.hasNext()) {
            Range<Long> range = rangeIterator.next();
            result.add(new IntegerPrimaryKeyIngestPosition((Long)range.getMinimum(), (Long)range.getMaximum()));
        }
        return result;
    }
}

