/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.id;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PipelineJobNotFoundException;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.core.job.type.JobCodeRegistry;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.util.InstanceTypeUtils;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;

public final class PipelineJobIdUtils {
    public static String marshal(PipelineJobId jobId) {
        return PipelineJobIdUtils.marshalPrefix(jobId.getJobType(), jobId.getContextKey()) + jobId.marshalSuffix();
    }

    private static String marshalPrefix(PipelineJobType jobType, PipelineContextKey contextKey) {
        InstanceType instanceType = contextKey.getInstanceType();
        String databaseName = instanceType == InstanceType.PROXY ? "" : contextKey.getDatabaseName();
        String databaseNameHex = Hex.encodeHexString((byte[])databaseName.getBytes(StandardCharsets.UTF_8), (boolean)true);
        String databaseNameLengthHex = Hex.encodeHexString((byte[])Shorts.toByteArray((short)((short)databaseNameHex.length())), (boolean)true);
        char encodedInstanceType = InstanceTypeUtils.encode(instanceType);
        return 'j' + jobType.getCode() + "02" + encodedInstanceType + databaseNameLengthHex + databaseNameHex;
    }

    public static PipelineJobType parseJobType(String jobId) {
        PipelineJobIdUtils.verifyJobId(jobId);
        return JobCodeRegistry.getJobType(jobId.substring(1, 3));
    }

    private static void verifyJobId(String jobId) {
        Preconditions.checkArgument((jobId.length() > 10 ? 1 : 0) != 0, (String)"Invalid job id length, job id: `%s`", (Object)jobId);
        Preconditions.checkArgument(('j' == jobId.charAt(0) ? 1 : 0) != 0, (String)"Invalid job id, first char: `%s`", (char)jobId.charAt(0));
    }

    public static PipelineContextKey parseContextKey(String jobId) {
        PipelineJobIdUtils.verifyJobId(jobId);
        String formatVersion = jobId.substring(3, 5);
        Preconditions.checkArgument((boolean)"02".equals(formatVersion), (Object)("Format version doesn't match, format version: " + formatVersion));
        char instanceType = jobId.charAt(5);
        short databaseNameLength = Shorts.fromByteArray((byte[])Hex.decodeHex((String)jobId.substring(6, 10)));
        String databaseName = new String(Hex.decodeHex((String)jobId.substring(10, 10 + databaseNameLength)), StandardCharsets.UTF_8);
        return new PipelineContextKey(databaseName, InstanceTypeUtils.decode(instanceType));
    }

    public static JobConfigurationPOJO getElasticJobConfigurationPOJO(String jobId) {
        JobConfigurationPOJO result = PipelineAPIFactory.getJobConfigurationAPI(PipelineJobIdUtils.parseContextKey(jobId)).getJobConfiguration(jobId);
        ShardingSpherePreconditions.checkNotNull((Object)result, () -> new PipelineJobNotFoundException(jobId));
        return result;
    }

    @Generated
    private PipelineJobIdUtils() {
    }
}

