/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.subscriber.dispatch;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDataSource;
import org.apache.shardingsphere.infra.rule.attribute.datasource.StaticDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.util.eventbus.EventSubscriber;
import org.apache.shardingsphere.mode.event.dispatch.state.storage.QualifiedDataSourceStateEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;

public class QualifiedDataSourceSubscriber
implements EventSubscriber {
    private final ContextManager contextManager;

    @Subscribe
    public synchronized void renew(QualifiedDataSourceStateEvent event) {
        QualifiedDataSource qualifiedDataSource = event.getQualifiedDataSource();
        Preconditions.checkState((boolean)this.contextManager.getMetaDataContexts().getMetaData().containsDatabase(qualifiedDataSource.getDatabaseName()), (String)"No database '%s' exists.", (Object)qualifiedDataSource.getDatabaseName());
        ShardingSphereDatabase database = this.contextManager.getMetaDataContexts().getMetaData().getDatabase(qualifiedDataSource.getDatabaseName());
        for (StaticDataSourceRuleAttribute each : database.getRuleMetaData().getAttributes(StaticDataSourceRuleAttribute.class)) {
            each.updateStatus(qualifiedDataSource, event.getStatus().getState());
        }
    }

    @Generated
    public QualifiedDataSourceSubscriber(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

