/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.metadata.persist.node.GlobalNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.config.AlterGlobalRuleConfigurationEvent;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;
import org.apache.shardingsphere.mode.path.GlobalNodePath;

public final class GlobalRuleDispatchEventBuilder
implements DispatchEventBuilder<DispatchEvent> {
    @Override
    public String getSubscribedKey() {
        return GlobalNode.getGlobalRuleRootNode();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public Optional<DispatchEvent> build(DataChangedEvent event) {
        if (GlobalNodePath.isRuleActiveVersionPath((String)event.getKey())) {
            return GlobalNodePath.getRuleName((String)event.getKey()).map(optional -> new AlterGlobalRuleConfigurationEvent(optional, event.getKey(), event.getValue()));
        }
        return Optional.empty();
    }
}

