/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule;

import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.shadow.rule.ShadowAlgorithmNameRule;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;
import org.apache.shardingsphere.shadow.spi.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.hint.HintShadowAlgorithm;

public final class ShadowTableRule {
    private final String tableName;
    private final Collection<String> shadowDataSources;
    private final Collection<String> hintShadowAlgorithmNames;
    private final Map<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> columnShadowAlgorithmNames;

    public ShadowTableRule(String tableName, Collection<String> shadowDataSources, Collection<String> shadowAlgorithmNames, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        this.tableName = tableName;
        this.shadowDataSources = shadowDataSources;
        this.hintShadowAlgorithmNames = this.getHintShadowAlgorithmNames(shadowAlgorithmNames, shadowAlgorithms);
        this.columnShadowAlgorithmNames = this.getColumnShadowAlgorithmRules(shadowAlgorithmNames, shadowAlgorithms);
    }

    private Collection<String> getHintShadowAlgorithmNames(Collection<String> shadowAlgorithmNames, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        return shadowAlgorithmNames.stream().filter(each -> shadowAlgorithms.get(each) instanceof HintShadowAlgorithm).collect(Collectors.toList());
    }

    private Map<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> getColumnShadowAlgorithmRules(Collection<String> shadowAlgorithmNames, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        EnumMap<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> result = new EnumMap<ShadowOperationType, Collection<ShadowAlgorithmNameRule>>(ShadowOperationType.class);
        for (String each : shadowAlgorithmNames) {
            ShadowAlgorithm shadowAlgorithm = shadowAlgorithms.get(each);
            if (!(shadowAlgorithm instanceof ColumnShadowAlgorithm)) continue;
            ShadowOperationType operationType = ((ColumnShadowAlgorithm)shadowAlgorithm).getShadowOperationType();
            result.computeIfAbsent(operationType, unused -> new LinkedList()).add(new ShadowAlgorithmNameRule(((ColumnShadowAlgorithm)shadowAlgorithm).getShadowColumn(), each));
        }
        return result;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public Collection<String> getShadowDataSources() {
        return this.shadowDataSources;
    }

    @Generated
    public Collection<String> getHintShadowAlgorithmNames() {
        return this.hintShadowAlgorithmNames;
    }

    @Generated
    public Map<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> getColumnShadowAlgorithmNames() {
        return this.columnShadowAlgorithmNames;
    }
}

