/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin;

import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributeKey;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributeType;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.SpanKind;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.StatusCode;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin.EventDataToAnnotation;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.EventData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.SpanData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.StatusData;
import org.apache.shardingsphere.shade.zipkin2.Endpoint;
import org.apache.shardingsphere.shade.zipkin2.Span;

final class OtelToZipkinSpanTransformer {
    private static final AttributeKey<String> SERVICE_NAME = AttributeKey.stringKey("service.name");
    private static final AttributeKey<String> PEER_SERVICE = AttributeKey.stringKey("peer.service");
    private static final AttributeKey<String> SERVER_SOCKET_ADDRESS = AttributeKey.stringKey("server.socket.address");
    private static final AttributeKey<Long> SERVER_SOCKET_PORT = AttributeKey.longKey("server.socket.port");
    static final String KEY_INSTRUMENTATION_SCOPE_NAME = "otel.scope.name";
    static final String KEY_INSTRUMENTATION_SCOPE_VERSION = "otel.scope.version";
    static final String KEY_INSTRUMENTATION_LIBRARY_NAME = "otel.library.name";
    static final String KEY_INSTRUMENTATION_LIBRARY_VERSION = "otel.library.version";
    static final String OTEL_DROPPED_ATTRIBUTES_COUNT = "otel.dropped_attributes_count";
    static final String OTEL_DROPPED_EVENTS_COUNT = "otel.dropped_events_count";
    static final String OTEL_STATUS_CODE = "otel.status_code";
    static final AttributeKey<String> STATUS_ERROR = AttributeKey.stringKey("error");
    private final Supplier<InetAddress> ipAddressSupplier;

    static OtelToZipkinSpanTransformer create(Supplier<InetAddress> ipAddressSupplier) {
        return new OtelToZipkinSpanTransformer(ipAddressSupplier);
    }

    private OtelToZipkinSpanTransformer(Supplier<InetAddress> ipAddressSupplier) {
        this.ipAddressSupplier = ipAddressSupplier;
    }

    Span generateSpan(SpanData spanData) {
        InstrumentationScopeInfo instrumentationScopeInfo;
        StatusData status;
        long startTimestamp = OtelToZipkinSpanTransformer.toEpochMicros(spanData.getStartEpochNanos());
        long endTimestamp = OtelToZipkinSpanTransformer.toEpochMicros(spanData.getEndEpochNanos());
        Span.Builder spanBuilder = Span.newBuilder().traceId(spanData.getTraceId()).id(spanData.getSpanId()).kind(OtelToZipkinSpanTransformer.toSpanKind(spanData)).name(spanData.getName()).timestamp(OtelToZipkinSpanTransformer.toEpochMicros(spanData.getStartEpochNanos())).duration(Math.max(1L, endTimestamp - startTimestamp)).localEndpoint(this.getLocalEndpoint(spanData)).remoteEndpoint(OtelToZipkinSpanTransformer.getRemoteEndpoint(spanData));
        if (spanData.getParentSpanContext().isValid()) {
            spanBuilder.parentId(spanData.getParentSpanId());
        }
        Attributes spanAttributes = spanData.getAttributes();
        spanAttributes.forEach((key, value) -> spanBuilder.putTag(key.getKey(), OtelToZipkinSpanTransformer.valueToString(key, value)));
        int droppedAttributes = spanData.getTotalAttributeCount() - spanAttributes.size();
        if (droppedAttributes > 0) {
            spanBuilder.putTag(OTEL_DROPPED_ATTRIBUTES_COUNT, String.valueOf(droppedAttributes));
        }
        if ((status = spanData.getStatus()).getStatusCode() != StatusCode.UNSET) {
            spanBuilder.putTag(OTEL_STATUS_CODE, status.getStatusCode().toString());
            if (status.getStatusCode() == StatusCode.ERROR && spanAttributes.get(STATUS_ERROR) == null) {
                spanBuilder.putTag(STATUS_ERROR.getKey(), OtelToZipkinSpanTransformer.nullToEmpty(status.getDescription()));
            }
        }
        if (!(instrumentationScopeInfo = spanData.getInstrumentationScopeInfo()).getName().isEmpty()) {
            spanBuilder.putTag(KEY_INSTRUMENTATION_SCOPE_NAME, instrumentationScopeInfo.getName());
            spanBuilder.putTag(KEY_INSTRUMENTATION_LIBRARY_NAME, instrumentationScopeInfo.getName());
        }
        if (instrumentationScopeInfo.getVersion() != null) {
            spanBuilder.putTag(KEY_INSTRUMENTATION_SCOPE_VERSION, instrumentationScopeInfo.getVersion());
            spanBuilder.putTag(KEY_INSTRUMENTATION_LIBRARY_VERSION, instrumentationScopeInfo.getVersion());
        }
        for (EventData eventData : spanData.getEvents()) {
            String annotation = EventDataToAnnotation.apply(eventData);
            spanBuilder.addAnnotation(OtelToZipkinSpanTransformer.toEpochMicros(eventData.getEpochNanos()), annotation);
        }
        int droppedEvents = spanData.getTotalRecordedEvents() - spanData.getEvents().size();
        if (droppedEvents > 0) {
            spanBuilder.putTag(OTEL_DROPPED_EVENTS_COUNT, String.valueOf(droppedEvents));
        }
        return spanBuilder.build();
    }

    private static String nullToEmpty(@Nullable String value) {
        return value != null ? value : "";
    }

    private Endpoint getLocalEndpoint(SpanData spanData) {
        Attributes resourceAttributes = spanData.getResource().getAttributes();
        Endpoint.Builder endpoint = Endpoint.newBuilder();
        endpoint.ip(this.ipAddressSupplier.get());
        String serviceNameValue = resourceAttributes.get(SERVICE_NAME);
        if (serviceNameValue == null) {
            serviceNameValue = Resource.getDefault().getAttribute(SERVICE_NAME);
        }
        if (serviceNameValue != null) {
            endpoint.serviceName(serviceNameValue);
        }
        return endpoint.build();
    }

    @Nullable
    private static Endpoint getRemoteEndpoint(SpanData spanData) {
        Attributes attributes;
        String serviceName;
        if ((spanData.getKind() == SpanKind.CLIENT || spanData.getKind() == SpanKind.PRODUCER) && (serviceName = (attributes = spanData.getAttributes()).get(PEER_SERVICE)) != null) {
            Endpoint.Builder endpoint = Endpoint.newBuilder();
            endpoint.serviceName(serviceName);
            endpoint.ip(attributes.get(SERVER_SOCKET_ADDRESS));
            Long port = attributes.get(SERVER_SOCKET_PORT);
            if (port != null) {
                endpoint.port(port.intValue());
            }
            return endpoint.build();
        }
        return null;
    }

    @Nullable
    private static Span.Kind toSpanKind(SpanData spanData) {
        switch (spanData.getKind()) {
            case SERVER: {
                return Span.Kind.SERVER;
            }
            case CLIENT: {
                return Span.Kind.CLIENT;
            }
            case PRODUCER: {
                return Span.Kind.PRODUCER;
            }
            case CONSUMER: {
                return Span.Kind.CONSUMER;
            }
            case INTERNAL: {
                return null;
            }
        }
        return null;
    }

    private static long toEpochMicros(long epochNanos) {
        return TimeUnit.NANOSECONDS.toMicros(epochNanos);
    }

    private static String valueToString(AttributeKey<?> key, Object attributeValue) {
        AttributeType type = key.getType();
        switch (type) {
            case STRING: 
            case BOOLEAN: 
            case LONG: 
            case DOUBLE: {
                return String.valueOf(attributeValue);
            }
            case STRING_ARRAY: 
            case BOOLEAN_ARRAY: 
            case LONG_ARRAY: 
            case DOUBLE_ARRAY: {
                return OtelToZipkinSpanTransformer.commaSeparated((List)attributeValue);
            }
        }
        throw new IllegalStateException("Unknown attribute type: " + (Object)((Object)type));
    }

    private static String commaSeparated(List<?> values2) {
        StringBuilder builder = new StringBuilder();
        for (Object value : values2) {
            if (builder.length() != 0) {
                builder.append(',');
            }
            builder.append(value);
        }
        return builder.toString();
    }
}

