/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.schema;

import io.swagger.v3.oas.models.media.Schema;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectProperty;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.schema.SchemaRecursiveValidatorTemplate;

public class SchemaTitleRequiredValidator
extends SchemaRecursiveValidatorTemplate {
    public static final String CONFIG_KEY = "schema.title.required";

    protected List<OasViolation> validateCurrentSchemaObject(OasValidationContext context, Schema oasObject, OasObjectPropertyLocation location) {
        if (StringUtils.isNotBlank((CharSequence)oasObject.get$ref())) {
            return Collections.emptyList();
        }
        OasObjectProperty parentProperty = location.getParent();
        if (OasObjectType.SCHEMA == parentProperty.getObjectType() || OasObjectType.COMPONENTS == parentProperty.getObjectType()) {
            return this.check(oasObject, location);
        }
        return Collections.emptyList();
    }

    private List<OasViolation> check(Schema oasObject, OasObjectPropertyLocation location) {
        if (StringUtils.isNotBlank((CharSequence)oasObject.getTitle())) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new OasViolation(location.property("title", null), "Required"));
    }
}

