/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.annotation;

import org.apache.servicecomb.toolkit.generator.annotation.MethodAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.context.OperationContext;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class AbstractHttpMethodMappingAnnotationProcessor<Annotation, Context>
implements MethodAnnotationProcessor<Annotation, Context> {
    protected void processPath(String[] paths, OperationContext operationContext) {
        if (null == paths || paths.length == 0) {
            return;
        }
        if (paths.length > 1) {
            throw new Error(String.format("not allowed multi path for %s:%s", operationContext.getMethod().getDeclaringClass().getName(), operationContext.getMethod().getName()));
        }
        operationContext.setPath(paths[0]);
    }

    protected void processMethod(RequestMethod requestMethod, OperationContext operationContext) {
        operationContext.setHttpMethod(requestMethod.name());
    }

    protected void processConsumes(String[] consumes, OperationContext operationContext) {
        if (null == consumes || consumes.length == 0) {
            return;
        }
        operationContext.setConsumers(consumes);
    }

    protected void processProduces(String[] produces, OperationContext operationContext) {
        if (null == produces || produces.length == 0) {
            return;
        }
        operationContext.setProduces(produces);
    }

    protected void processHeaders(String[] headers, OperationContext operationContext) {
        if (null == headers || headers.length == 0) {
            return;
        }
        operationContext.setHeaders(headers);
    }
}

