/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Span;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import com.google.common.eventbus.Subscribe;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.tracing.zipkin.HttpClientRequestWrapper;
import org.apache.servicecomb.tracing.zipkin.HttpClientResponseWrapper;
import org.apache.servicecomb.tracing.zipkin.HttpServeRequestWrapper;
import org.apache.servicecomb.tracing.zipkin.HttpServerResponseWrapper;
import org.springframework.beans.factory.annotation.Autowired;

public class ZipkinTracingFilter {
    public static final String CONTEXT_TRACE_REQUEST = "x-trace-request";
    public static final String CONTEXT_TRACE_HANDLER = "x-trace-handler";
    public static final String CONTEXT_TRACE_SPAN = "x-trace-span";
    public static final String CONTEXT_TRACE_EDGE_REQUEST = "x-trace-edge-request";
    public static final String CONTEXT_TRACE_EDGE_HANDLER = "x-trace-edge-handler";
    public static final String CONTEXT_TRACE_EDGE_SPAN = "x-trace-edge-span";
    private HttpTracing httpTracing;

    public ZipkinTracingFilter() {
        EventManager.register((Object)this);
    }

    @Autowired
    public void setHttpTracing(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
    }

    @Subscribe
    public void onInvocationStartEvent(InvocationStartEvent event) {
        Invocation invocation = event.getInvocation();
        if (invocation.isProducer()) {
            HttpServerHandler handler = HttpServerHandler.create((HttpTracing)this.httpTracing);
            HttpServeRequestWrapper request = new HttpServeRequestWrapper(invocation);
            Span span = handler.handleReceive((HttpServerRequest)request);
            invocation.addLocalContext(CONTEXT_TRACE_SPAN, (Object)span);
            invocation.addLocalContext(CONTEXT_TRACE_HANDLER, (Object)handler);
            invocation.addLocalContext(CONTEXT_TRACE_REQUEST, (Object)request);
        } else if (invocation.isConsumer()) {
            Span parentSpan = (Span)invocation.getLocalContext(CONTEXT_TRACE_SPAN);
            HttpClientHandler handler = HttpClientHandler.create((HttpTracing)this.httpTracing);
            HttpClientRequestWrapper request = new HttpClientRequestWrapper(invocation);
            Span span = handler.handleSendWithParent((HttpClientRequest)request, parentSpan == null ? null : parentSpan.context());
            invocation.addLocalContext(CONTEXT_TRACE_HANDLER, (Object)handler);
            invocation.addLocalContext(CONTEXT_TRACE_REQUEST, (Object)request);
            invocation.addLocalContext(CONTEXT_TRACE_SPAN, (Object)span);
        } else {
            HttpServerHandler serverHandler = HttpServerHandler.create((HttpTracing)this.httpTracing);
            HttpServeRequestWrapper serverRequest = new HttpServeRequestWrapper(invocation);
            Span serverSpan = serverHandler.handleReceive((HttpServerRequest)serverRequest);
            invocation.addLocalContext(CONTEXT_TRACE_EDGE_SPAN, (Object)serverSpan);
            invocation.addLocalContext(CONTEXT_TRACE_EDGE_HANDLER, (Object)serverHandler);
            invocation.addLocalContext(CONTEXT_TRACE_EDGE_REQUEST, (Object)serverRequest);
            HttpClientHandler clientHandler = HttpClientHandler.create((HttpTracing)this.httpTracing);
            HttpClientRequestWrapper clientRequest = new HttpClientRequestWrapper(invocation);
            Span clientSpan = clientHandler.handleSendWithParent((HttpClientRequest)clientRequest, serverSpan.context());
            invocation.addLocalContext(CONTEXT_TRACE_HANDLER, (Object)clientHandler);
            invocation.addLocalContext(CONTEXT_TRACE_REQUEST, (Object)clientRequest);
            invocation.addLocalContext(CONTEXT_TRACE_SPAN, (Object)clientSpan);
        }
    }

    @Subscribe
    public void onInvocationFinishEvent(InvocationFinishEvent event) {
        Invocation invocation = event.getInvocation();
        if (invocation.isProducer()) {
            HttpServerHandler handler = (HttpServerHandler)invocation.getLocalContext(CONTEXT_TRACE_HANDLER);
            Span span = (Span)invocation.getLocalContext(CONTEXT_TRACE_SPAN);
            handler.handleSend((HttpServerResponse)new HttpServerResponseWrapper(invocation, event.getResponse(), (HttpServeRequestWrapper)invocation.getLocalContext(CONTEXT_TRACE_REQUEST)), span);
        } else if (invocation.isConsumer()) {
            HttpClientHandler handler = (HttpClientHandler)invocation.getLocalContext(CONTEXT_TRACE_HANDLER);
            Span span = (Span)invocation.getLocalContext(CONTEXT_TRACE_SPAN);
            handler.handleReceive((HttpClientResponse)new HttpClientResponseWrapper(invocation, event.getResponse(), (HttpClientRequestWrapper)invocation.getLocalContext(CONTEXT_TRACE_REQUEST)), span);
        } else {
            HttpClientHandler clientHandler = (HttpClientHandler)invocation.getLocalContext(CONTEXT_TRACE_HANDLER);
            Span clientSpan = (Span)invocation.getLocalContext(CONTEXT_TRACE_SPAN);
            clientHandler.handleReceive((HttpClientResponse)new HttpClientResponseWrapper(invocation, event.getResponse(), (HttpClientRequestWrapper)invocation.getLocalContext(CONTEXT_TRACE_REQUEST)), clientSpan);
            HttpServerHandler serverHandler = (HttpServerHandler)invocation.getLocalContext(CONTEXT_TRACE_EDGE_HANDLER);
            Span serverSpan = (Span)invocation.getLocalContext(CONTEXT_TRACE_EDGE_SPAN);
            serverHandler.handleSend((HttpServerResponse)new HttpServerResponseWrapper(invocation, event.getResponse(), (HttpServeRequestWrapper)invocation.getLocalContext(CONTEXT_TRACE_EDGE_REQUEST)), serverSpan);
        }
    }
}

