/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

public class ExceptionUtils {
    private static final int DEPTH = 5;

    private ExceptionUtils() {
    }

    public static String getExceptionMessageWithoutTrace(Throwable e) {
        StringBuilder result = new StringBuilder();
        ExceptionUtils.appendExceptionInfo(e, result);
        int depth = 5;
        for (Throwable cause = e.getCause(); cause != null && depth-- > 0; cause = cause.getCause()) {
            result.append(";");
            ExceptionUtils.appendExceptionInfo(cause, result);
        }
        return result.toString();
    }

    private static void appendExceptionInfo(Throwable e, StringBuilder result) {
        result.append("cause:");
        result.append(e.getClass().getSimpleName());
        result.append(",message:");
        result.append(e.getMessage());
    }
}

