/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.patterns;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class LongTaskTimer
implements com.netflix.spectator.api.LongTaskTimer {
    private static final double NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final Clock clock;
    private final Id id;
    private final ConcurrentMap<Long, Long> tasks = new ConcurrentHashMap<Long, Long>();
    private final AtomicLong nextTask = new AtomicLong(0L);

    public static LongTaskTimer get(Registry registry, Id id) {
        ConcurrentMap<Id, Object> state = registry.state();
        Object obj = Utils.computeIfAbsent(state, id, i -> {
            LongTaskTimer timer = new LongTaskTimer(registry, id);
            ((PolledMeter.Builder)PolledMeter.using(registry).withId(id).withTag(Statistic.activeTasks)).monitorValue(timer, LongTaskTimer::activeTasks);
            ((PolledMeter.Builder)PolledMeter.using(registry).withId(id).withTag(Statistic.duration)).monitorValue(timer, t -> (double)t.duration() / NANOS_PER_SECOND);
            return timer;
        });
        if (!(obj instanceof LongTaskTimer)) {
            Utils.propagateTypeError(registry, id, LongTaskTimer.class, obj.getClass());
            obj = new LongTaskTimer(new NoopRegistry(), id);
        }
        return (LongTaskTimer)obj;
    }

    private LongTaskTimer(Registry registry, Id id) {
        this.clock = registry.clock();
        this.id = id;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public long start() {
        long task = this.nextTask.getAndIncrement();
        this.tasks.put(task, this.clock.monotonicTime());
        return task;
    }

    @Override
    public long stop(long task) {
        Long startTime = (Long)this.tasks.get(task);
        if (startTime != null) {
            this.tasks.remove(task);
            return this.clock.monotonicTime() - startTime;
        }
        return -1L;
    }

    @Override
    public long duration(long task) {
        Long startTime = (Long)this.tasks.get(task);
        return startTime != null ? this.clock.monotonicTime() - startTime : -1L;
    }

    @Override
    public long duration() {
        long now = this.clock.monotonicTime();
        long sum = 0L;
        Iterator iterator = this.tasks.values().iterator();
        while (iterator.hasNext()) {
            long startTime = (Long)iterator.next();
            sum += now - startTime;
        }
        return sum;
    }

    @Override
    public int activeTasks() {
        return this.tasks.size();
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>(2);
        long now = this.clock.wallTime();
        double durationSeconds = (double)this.duration() / NANOS_PER_SECOND;
        ms.add(new Measurement(this.id.withTag(Statistic.duration), now, durationSeconds));
        ms.add(new Measurement(this.id.withTag(Statistic.activeTasks), now, this.activeTasks()));
        return ms;
    }
}

