/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RewriteResponseHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String REGEXP_KEY = "regexp";
    public static final String REPLACEMENT_KEY = "replacement";

    public RewriteResponseHeaderGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name", REGEXP_KEY, REPLACEMENT_KEY);
    }

    @Override
    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> chain.filter(exchange).then(Mono.fromRunnable(() -> this.rewriteHeader(exchange, config)));
    }

    protected void rewriteHeader(ServerWebExchange exchange, Config config) {
        String name = config.getName();
        String value = exchange.getResponse().getHeaders().getFirst(name);
        if (value == null) {
            return;
        }
        String newValue = this.rewrite(value, config.getRegexp(), config.getReplacement());
        exchange.getResponse().getHeaders().set(name, newValue);
    }

    String rewrite(String value, String regexp, String replacement) {
        return value.replaceAll(regexp, replacement.replace("$\\", "$"));
    }

    public static class Config
    extends AbstractGatewayFilterFactory.NameConfig {
        private String regexp;
        private String replacement;

        public String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(String regexp) {
            this.regexp = regexp;
            return this;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public Config setReplacement(String replacement) {
            this.replacement = replacement;
            return this;
        }
    }
}

