/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.constants;

import javax.annotation.Nullable;

public enum DataFormatType {
    BUFR(null),
    ESML(null),
    GEMPAK(null),
    GINI(null),
    GRIB1("GRIB-1"),
    GRIB2("GRIB-2"),
    HDF4(null),
    HDF5(null),
    MCIDAS_AREA("McIDAS-AREA"),
    NCML("NcML"),
    NETCDF("NetCDF"),
    NETCDF4("NetCDF-4"),
    NEXRAD2(null),
    NIDS(null),
    GIF("image/gif"),
    JPEG("image/jpeg"),
    TIFF("image/tiff"),
    CSV("text/csv"),
    HTML("text/html"),
    PLAIN("text/plain"),
    TSV("text/tab-separated-values"),
    XML("text/xml"),
    MPEG("video/mpeg"),
    QUICKTIME("video/quicktime"),
    REALTIME("video/realtime");

    private final String desc;

    private DataFormatType(String desc) {
        this.desc = desc == null ? this.toString() : desc;
    }

    @Nullable
    public static DataFormatType getType(String name) {
        if (name == null) {
            return null;
        }
        for (DataFormatType m3 : DataFormatType.values()) {
            if (m3.desc.equalsIgnoreCase(name)) {
                return m3;
            }
            if (!m3.toString().equalsIgnoreCase(name)) continue;
            return m3;
        }
        return null;
    }

    @Nullable
    public String getDescription() {
        return this.desc;
    }
}

