/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.snowflake.snowsql;

import java.util.Arrays;
import org.apache.sedona.common.Constructors;
import org.apache.sedona.common.Functions;
import org.apache.sedona.common.enums.FileDataSplitter;
import org.apache.sedona.common.utils.FormatUtils;
import org.apache.sedona.common.utils.GeomUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;

public class GeometrySerde {
    public static GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public static byte[] serialize(Geometry geom) {
        return Functions.asEWKB(geom);
    }

    public static String serGeoJson(Geometry geom) {
        return Functions.asGeoJson(geom);
    }

    public static String serGeoJson(Geometry[] geoms) {
        return Functions.asGeoJson(Functions.createMultiGeometry(geoms));
    }

    public static byte[] serialize(Geometry[] geoms) {
        return GeometrySerde.serialize(Functions.createMultiGeometry(geoms));
    }

    public static Geometry deserialize(byte[] bytes) {
        try {
            return Constructors.geomFromWKB(bytes);
        }
        catch (ParseException e) {
            String msg = String.format("Failed to parse WKB(printed through Arrays.toString(bytes)): %s, error: %s", Arrays.toString(bytes), e.getMessage());
            throw new IllegalArgumentException(msg);
        }
    }

    public static Geometry deserGeoJson(String geoJson) {
        FormatUtils formatUtils = new FormatUtils(FileDataSplitter.GEOJSON, false);
        try {
            return formatUtils.readGeometry(geoJson);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Geometry[] deserGeoJson2List(String geoJson) {
        Geometry geom;
        FormatUtils formatUtils = new FormatUtils(FileDataSplitter.GEOJSON, false);
        try {
            geom = formatUtils.readGeometry(geoJson);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        assert (geom instanceof GeometryCollection);
        return GeomUtils.getSubGeometries(geom);
    }

    public static Geometry[] deserialize2List(byte[] bytes) {
        Geometry geom = GeometrySerde.deserialize(bytes);
        assert (geom instanceof GeometryCollection);
        return GeomUtils.getSubGeometries(geom);
    }
}

