/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sedona_sql.io.GeotiffFileWriter;
import org.apache.spark.sql.sedona_sql.io.GeotiffSchema$;
import org.apache.spark.sql.sedona_sql.io.ImageReadOptions;
import org.apache.spark.sql.sedona_sql.io.ImageWriteOptions;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055c!B\u0004\t\u00019!\u0002\"B\u0015\u0001\t\u0003Y\u0003\"\u0002\u0018\u0001\t\u0003z\u0003\"\u00022\u0001\t\u0003\u001a\u0007\"B:\u0001\t\u0003\"\b\"B;\u0001\t#2\bbBA\u001c\u0001\u0011%\u0011\u0011\b\u0002\u0012\u000f\u0016|G/\u001b4g\r&dWMR8s[\u0006$(BA\u0005\u000b\u0003\tIwN\u0003\u0002\f\u0019\u0005Q1/\u001a3p]\u0006|6/\u001d7\u000b\u00055q\u0011aA:rY*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0005\u0003\u0001+m\u0019\u0003C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005YA-\u0019;bg>,(oY3t\u0015\t\u0001C\"A\u0005fq\u0016\u001cW\u000f^5p]&\u0011!%\b\u0002\u000b\r&dWMR8s[\u0006$\bC\u0001\u0013(\u001b\u0005)#B\u0001\u0014\r\u0003\u001d\u0019x.\u001e:dKNL!\u0001K\u0013\u0003%\u0011\u000bG/Y*pkJ\u001cWMU3hSN$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tA\u0006\u0005\u0002.\u00015\t\u0001\"A\u0006j]\u001a,'oU2iK6\fG\u0003\u0002\u0019:\u007f=\u00032AF\u00194\u0013\t\u0011tC\u0001\u0004PaRLwN\u001c\t\u0003i]j\u0011!\u000e\u0006\u0003m1\tQ\u0001^=qKNL!\u0001O\u001b\u0003\u0015M#(/^2u)f\u0004X\rC\u0003;\u0005\u0001\u00071(\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002={5\tA\"\u0003\u0002?\u0019\ta1\u000b]1sWN+7o]5p]\")\u0001I\u0001a\u0001\u0003\u00069q\u000e\u001d;j_:\u001c\b\u0003\u0002\"J\u00192s!aQ$\u0011\u0005\u0011;R\"A#\u000b\u0005\u0019S\u0013A\u0002\u001fs_>$h(\u0003\u0002I/\u00051\u0001K]3eK\u001aL!AS&\u0003\u00075\u000b\u0007O\u0003\u0002I/A\u0011!)T\u0005\u0003\u001d.\u0013aa\u0015;sS:<\u0007\"\u0002)\u0003\u0001\u0004\t\u0016!\u00024jY\u0016\u001c\bc\u0001*X5:\u00111+\u0016\b\u0003\tRK\u0011\u0001G\u0005\u0003-^\tq\u0001]1dW\u0006<W-\u0003\u0002Y3\n\u00191+Z9\u000b\u0005Y;\u0002CA.a\u001b\u0005a&BA/_\u0003\t17O\u0003\u0002`!\u00051\u0001.\u00193p_BL!!\u0019/\u0003\u0015\u0019KG.Z*uCR,8/\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\rF\u0003eO\"\u0004\u0018\u000f\u0005\u0002\u001dK&\u0011a-\b\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u0006u\r\u0001\ra\u000f\u0005\u0006S\u000e\u0001\rA[\u0001\u0004U>\u0014\u0007CA6o\u001b\u0005a'BA7_\u0003%i\u0017\r\u001d:fIV\u001cW-\u0003\u0002pY\n\u0019!j\u001c2\t\u000b\u0001\u001b\u0001\u0019A!\t\u000bI\u001c\u0001\u0019A\u001a\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017-A\u0005tQ>\u0014HOT1nKR\tA*A\u0006ck&dGMU3bI\u0016\u0014HcD<\u0002\u000e\u0005=\u0011\u0011CA\u000b\u00033\t)#a\n\u0011\tYA(0`\u0005\u0003s^\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005qY\u0018B\u0001?\u001e\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0007\u0003\u0002*\u007f\u0003\u0003I!a`-\u0003\u0011%#XM]1u_J\u0004B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fa\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005-\u0011Q\u0001\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003;\u000b\u0001\u00071\bC\u0003s\u000b\u0001\u00071\u0007\u0003\u0004\u0002\u0014\u0015\u0001\raM\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"1\u0011qC\u0003A\u0002M\naB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0002\u001c\u0015\u0001\r!!\b\u0002\u000f\u0019LG\u000e^3sgB!!kVA\u0010!\r!\u0013\u0011E\u0005\u0004\u0003G)#A\u0002$jYR,'\u000fC\u0003A\u000b\u0001\u0007\u0011\tC\u0004\u0002*\u0015\u0001\r!a\u000b\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\tDX\u0001\u0005G>tg-\u0003\u0003\u00026\u0005=\"!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u000bjgZ\u000bG.\u001b3HK>$\u0016N\u001a4TG\",W.\u0019\u000b\u0007\u0003w\t\t%a\u0013\u0011\u0007Y\ti$C\u0002\u0002@]\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002D\u0019\u0001\r!!\u0012\u0002#%l\u0017mZ3Xe&$Xm\u00149uS>t7\u000fE\u0002.\u0003\u000fJ1!!\u0013\t\u0005EIU.Y4f/JLG/Z(qi&|gn\u001d\u0005\u0006e\u001a\u0001\ra\r")
public class GeotiffFileFormat
implements FileFormat,
DataSourceRegister {
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return FileFormat.isSplitable$((FileFormat)this, (SparkSession)sparkSession, options, (Path)path);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType) {
        return FileFormat.supportDataType$((FileFormat)this, (DataType)dataType);
    }

    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$((FileFormat)this, (String)name);
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)GeotiffSchema$.MODULE$.imageSchema());
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        ImageWriteOptions imageWriteOptions = new ImageWriteOptions(options);
        if (!this.isValidGeoTiffSchema(imageWriteOptions, dataSchema)) {
            throw new IllegalArgumentException("Invalid GeoTiff Schema");
        }
        return new OutputWriterFactory(null, imageWriteOptions){
            private final ImageWriteOptions imageWriteOptions$1;

            public String getFileExtension(TaskAttemptContext context) {
                return "";
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new GeotiffFileWriter(path, this.imageWriteOptions$1, dataSchema, context);
            }
            {
                this.imageWriteOptions$1 = imageWriteOptions$1;
            }
        };
    }

    public String shortName() {
        return "geotiff";
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0 & Serializable)() -> "Image data source only produces a single data column named \"image\".");
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        ImageReadOptions imageSourceOptions = new ImageReadOptions(options);
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
            if (!imageSourceOptions.dropInvalid() && requiredSchema.isEmpty()) {
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnsafeRow[]{emptyUnsafeRow}));
            } else {
                Iterator filteredResult;
                byte[] byArray;
                String origin = file.filePath();
                Path path = new Path(origin);
                FileSystem fs = path.getFileSystem(((SerializableConfiguration)broadcastedHadoopConf.value()).value());
                FSDataInputStream stream = fs.open(path);
                try {
                    byArray = ByteStreams.toByteArray((InputStream)stream);
                }
                finally {
                    Closeables.close((Closeable)stream, true);
                }
                byte[] bytes = byArray;
                Option<Row> resultOpt = GeotiffSchema$.MODULE$.decode(origin, bytes, imageSourceOptions);
                Iterator iterator2 = filteredResult = imageSourceOptions.dropInvalid() ? Option$.MODULE$.option2Iterable(resultOpt).toIterator() : package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{(Row)resultOpt.getOrElse((Function0 & Serializable)() -> GeotiffSchema$.MODULE$.invalidImageRow(origin))}));
                if (requiredSchema.isEmpty()) {
                    iterator = filteredResult.map((Function1 & Serializable)x$1 -> emptyUnsafeRow);
                } else {
                    ExpressionEncoder.Serializer converter = RowEncoder$.MODULE$.apply(requiredSchema).createSerializer();
                    iterator = filteredResult.map((Function1 & Serializable)row -> converter.apply(row));
                }
            }
            return iterator;
        };
    }

    private boolean isValidGeoTiffSchema(ImageWriteOptions imageWriteOptions, StructType dataSchema) {
        StructType schemaFields;
        String[] fields = dataSchema.fieldNames();
        return !(ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Object)imageWriteOptions.colImage()) ? (schemaFields = (StructType)dataSchema.fields()[dataSchema.fieldIndex(imageWriteOptions.colImage())].dataType()).fieldNames().length != 6 : fields.length != 6);
    }

    public GeotiffFileFormat() {
        FileFormat.$init$((FileFormat)this);
    }
}

