/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.GeoDataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t=a\u0001B\u000b\u0017\u0001\u0015B\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0015\")!\u000b\u0001C\u0001'\")!\u000b\u0001C\u0001-\")q\u000b\u0001C!1\")\u0011\r\u0001C!E\")1\u000e\u0001C!Y\")\u0001\u000f\u0001C\u0001c\")1\u000f\u0001C!i\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\t9\u000b\u0001C!\u0003S;q!!-\u0017\u0011\u0003\t\u0019L\u0002\u0004\u0016-!\u0005\u0011Q\u0017\u0005\u0007%>!\t!a3\t\u000f\u00055w\u0002\"\u0001\u0002P\"9\u0011\u0011\\\b\u0005\n\u0005m\u0007bBA|\u001f\u0011%\u0011\u0011 \u0005\n\u0003\u007f|\u0011\u0011!C\u0005\u0005\u0003\u0011AcR3p!\u0006\u0014\u0018/^3u\r&dWMR8s[\u0006$(BA\f\u0019\u0003\u001d\u0001\u0018M]9vKRT!!\u0007\u000e\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00037q\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005uq\u0012aA:rY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u00011#F\f\u001b;!\t9\u0003&D\u0001\u0017\u0013\tIcCA\tQCJ\fX/\u001a;GS2,gi\u001c:nCR\u0004\"a\u000b\u0017\u000e\u0003aI!!\f\r\u0003\u0015\u0019KG.\u001a$pe6\fG\u000f\u0005\u00020e5\t\u0001G\u0003\u000229\u000591o\\;sG\u0016\u001c\u0018BA\u001a1\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]r\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005e2$a\u0002'pO\u001eLgn\u001a\t\u0003w\u0015s!\u0001\u0010\"\u000f\u0005u\u0002U\"\u0001 \u000b\u0005}\"\u0013A\u0002\u001fs_>$h(C\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019E)A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u0005K!AR$\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\r#\u0015!D:qCRL\u0017\r\u001c$jYR,'/F\u0001K!\rYEJT\u0007\u0002\t&\u0011Q\n\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001dz\u0015B\u0001)\u0017\u0005]9Um\u001c)beF,X\r^*qCRL\u0017\r\u001c$jYR,'/\u0001\bta\u0006$\u0018.\u00197GS2$XM\u001d\u0011\u0002\rqJg.\u001b;?)\t!V\u000b\u0005\u0002(\u0001!)\u0001j\u0001a\u0001\u0015R\tA+A\u0005tQ>\u0014HOT1nKR\t\u0011\f\u0005\u0002[=:\u00111\f\u0018\t\u0003{\u0011K!!\u0018#\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;\u0012\u000ba!Z9vC2\u001cHCA2g!\tYE-\u0003\u0002f\t\n9!i\\8mK\u0006t\u0007\"B4\u0007\u0001\u0004A\u0017!B8uQ\u0016\u0014\bCA&j\u0013\tQGIA\u0002B]f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002[B\u00111J\\\u0005\u0003_\u0012\u00131!\u00138u\u0003U9\u0018\u000e\u001e5Ta\u0006$\u0018.\u00197Qe\u0016$\u0017nY1uKN$\"\u0001\u0016:\t\u000b!C\u0001\u0019\u0001(\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\u0007kr\f)!a\u0004\u0011\u0007-ce\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002z9\u0005)A/\u001f9fg&\u00111\u0010\u001f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B?\n\u0001\u0004q\u0018\u0001D:qCJ\\7+Z:tS>t\u0007cA@\u0002\u00025\tA$C\u0002\u0002\u0004q\u0011Ab\u00159be.\u001cVm]:j_:Dq!a\u0002\n\u0001\u0004\tI!\u0001\u0006qCJ\fW.\u001a;feN\u0004RAWA\u00063fK1!!\u0004a\u0005\ri\u0015\r\u001d\u0005\b\u0003#I\u0001\u0019AA\n\u0003\u00151\u0017\u000e\\3t!\u0015Y\u0014QCA\r\u0013\r\t9b\u0012\u0002\u0004'\u0016\f\b\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0003MNT1!a\t!\u0003\u0019A\u0017\rZ8pa&!\u0011qEA\u000f\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u000b\u0003[\t\u0019$!\u000e\u0002F\u0005%\u0003cA\u0016\u00020%\u0019\u0011\u0011\u0007\r\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000buT\u0001\u0019\u0001@\t\u000f\u0005]\"\u00021\u0001\u0002:\u0005\u0019!n\u001c2\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{QA!a\u0010\u0002\"\u0005IQ.\u00199sK\u0012,8-Z\u0005\u0005\u0003\u0007\niDA\u0002K_\nDq!a\u0012\u000b\u0001\u0004\tI!A\u0004paRLwN\\:\t\r\u0005-#\u00021\u0001w\u0003)!\u0017\r^1TG\",W.Y\u0001\u001fEVLG\u000e\u001a*fC\u0012,'oV5uQB\u000b'\u000f^5uS>tg+\u00197vKN$\u0002#!\u0015\u0002p\u0005E\u00141OA<\u0003w\n9)!#\u0011\u000f-\u000b\u0019&a\u0016\u0002^%\u0019\u0011Q\u000b#\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0016\u0002Z%\u0019\u00111\f\r\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004RaOA0\u0003GJ1!!\u0019H\u0005!IE/\u001a:bi>\u0014\b\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%D$\u0001\u0005dCR\fG._:u\u0013\u0011\ti'a\u001a\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006{.\u0001\rA \u0005\u0007\u0003\u0017Z\u0001\u0019\u0001<\t\r\u0005U4\u00021\u0001w\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007BBA=\u0017\u0001\u0007a/\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000f\u0005u4\u00021\u0001\u0002\u0000\u00059a-\u001b7uKJ\u001c\b#B\u001e\u0002\u0016\u0005\u0005\u0005cA\u0018\u0002\u0004&\u0019\u0011Q\u0011\u0019\u0003\r\u0019KG\u000e^3s\u0011\u001d\t9e\u0003a\u0001\u0003\u0013Aq!a#\f\u0001\u0004\ti)\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b\t#\u0001\u0003d_:4\u0017\u0002BAL\u0003#\u0013QbQ8oM&<WO]1uS>t\u0017aD:vaB|'\u000f\u001e#bi\u0006$\u0016\u0010]3\u0015\u0007\r\fi\nC\u0004\u0002 2\u0001\r!!)\u0002\u0011\u0011\fG/\u0019+za\u0016\u00042a^AR\u0013\r\t)\u000b\u001f\u0002\t\t\u0006$\u0018\rV=qK\u0006a1/\u001e9q_J$()\u0019;dQR)1-a+\u0002.\")Q0\u0004a\u0001}\"1\u0011qV\u0007A\u0002Y\faa]2iK6\f\u0017\u0001F$f_B\u000b'/];fi\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002(\u001fM1q\"a.5\u0003{\u00032aSA]\u0013\r\tY\f\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005}\u0016\u0011Z\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006\u0011\u0011n\u001c\u0006\u0003\u0003\u000f\fAA[1wC&\u0019a)!1\u0015\u0005\u0005M\u0016AF7fe\u001e,7k\u00195f[\u0006\u001c\u0018J\u001c)be\u0006dG.\u001a7\u0015\u000fU\f\t.a5\u0002X\"9\u0011qA\tA\u0002\u0005%\u0001bBAk#\u0001\u0007\u00111C\u0001\rM&dWm\u001d+p)>,8\r\u001b\u0005\u0006{F\u0001\rA`\u0001\u0015e\u0016\fGmU2iK6\fgI]8n\r>|G/\u001a:\u0015\u000bY\fi.!<\t\u000f\u0005}'\u00031\u0001\u0002b\u00061am\\8uKJ\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0005\u0003G\t9O\u0003\u0002\u0018A%!\u00111^As\u0005\u00191un\u001c;fe\"9\u0011q\u001e\nA\u0002\u0005E\u0018!C2p]Z,'\u000f^3s!\r9\u00131_\u0005\u0004\u0003k4\"\u0001I$f_B\u000b'/];fiR{7\u000b]1sWN\u001b\u0007.Z7b\u0007>tg/\u001a:uKJ\fq\u0003Z3tKJL\u0017\r\\5{KN\u001b\u0007.Z7b'R\u0014\u0018N\\4\u0015\u0007U\fY\u0010\u0003\u0004\u0002~N\u0001\r!W\u0001\rg\u000eDW-\\1TiJLgnZ\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0007\u0001BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0005\u0005\u0013\t)-\u0001\u0003mC:<\u0017\u0002\u0002B\u0007\u0005\u000f\u0011aa\u00142kK\u000e$\b")
public class GeoParquetFileFormat
extends ParquetFileFormat {
    private final Option<GeoParquetSpatialFilter> spatialFilter;

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    public String shortName() {
        return "geoparquet";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof GeoParquetFileFormat)) return false;
        Option<GeoParquetSpatialFilter> option = ((GeoParquetFileFormat)((Object)other)).spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = this.spatialFilter();
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public GeoParquetFileFormat withSpatialPredicates(GeoParquetSpatialFilter spatialFilter) {
        return new GeoParquetFileFormat((Option<GeoParquetSpatialFilter>)new Some((Object)spatialFilter));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return GeoParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sparkSession.sessionState().conf().writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sparkSession.sessionState().conf().parquetOutputTimestampType().toString());
        try {
            String fieldIdWriteEnabled = SQLConf$.MODULE$.get().getConfString("spark.sql.parquet.fieldId.write.enabled");
            conf.set("spark.sql.parquet.fieldId.write.enabled", fieldIdWriteEnabled);
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").toString()).append(" create job summaries. ").append(new StringBuilder(58).append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString()).toString());
        }
        conf.set("parquet.write.support.class", GeoParquetWriteSupport.class.getName());
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = new Path(new URI(file.filePath()));
            ParquetInputSplit split = new ParquetInputSplit(filePath, file.start(), file.start() + file.length(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), null);
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            FileMetaData footerFileMetaData = ParquetFileReader.readFooter((Configuration)sharedConf, (Path)filePath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData();
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                GeoParquetFilters parquetFilters = new GeoParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$2 -> parquetFilters.createFilter((Filter)x$2))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            boolean shouldScanFile = GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(footerFileMetaData.getKeyValueMetaData()).forall((Function1 & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$5(this, metadata)));
            if (!shouldScanFile) {
                iterator = package$.MODULE$.Seq().empty().iterator();
            } else {
                ParquetRecordReader parquetRecordReader;
                None$ convertTz = timestampConversion && !GeoParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
                Map map = footerFileMetaData.getKeyValueMetaData();
                Enumeration.Value datetimeRebaseMode = GeoDataSourceUtils$.MODULE$.datetimeRebaseMode((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map.get(x$1), SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_REBASE_MODE_IN_READ()));
                Map map2 = footerFileMetaData.getKeyValueMetaData();
                Enumeration.Value int96RebaseMode = GeoDataSourceUtils$.MODULE$.int96RebaseMode((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map2.get(x$1), SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_READ()));
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
                if (pushed.isDefined()) {
                    ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
                }
                Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
                if (enableVectorizedReader) {
                    this.logWarning((Function0 & Serializable)() -> "GeoParquet currently does not support vectorized reader. Falling back to parquet-mr");
                }
                this.logDebug((Function0 & Serializable)() -> "Falling back to parquet-mr");
                GeoParquetReadSupport readSupport = new GeoParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseMode, int96RebaseMode);
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReaderIterator iter = new RecordReaderIterator((RecordReader)reader);
                taskContext.foreach((Function1 & Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable)x$5 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((IterableOnce)partitionSchema.toAttributes());
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    iterator = iter.map((Function1)unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    iterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            return iterator;
        };
    }

    public boolean supportDataType(DataType dataType) {
        return super.supportDataType(dataType);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$5(GeoParquetFileFormat $this, GeoParquetMetaData metadata) {
        return $this.spatialFilter().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.evaluate(metadata.columns())));
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public GeoParquetFileFormat(Option<GeoParquetSpatialFilter> spatialFilter) {
        this.spatialFilter = spatialFilter;
    }

    public GeoParquetFileFormat() {
        this((Option<GeoParquetSpatialFilter>)None$.MODULE$);
    }
}

