/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetToSparkSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\t\u0013\u0001\u0005B\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005O!)a\u0006\u0001C\u0001_!)a\u0006\u0001C\u0001g!)a\u0006\u0001C\u0001y!)Q\t\u0001C!\r\")Q\t\u0001C\u0005-\")1\f\u0001C\u00019\")Q\r\u0001C\u0005M\")A\u000e\u0001C\u0005[\")q\u000e\u0001C\u0001a\u001eI\u0011\u0011\u0001\n\u0002\u0002#\u0005\u00111\u0001\u0004\t#I\t\t\u0011#\u0001\u0002\u0006!1a&\u0004C\u0001\u0003\u001bA\u0011\"a\u0004\u000e#\u0003%\t!!\u0005\t\u0013\u0005\u001dR\"%A\u0005\u0002\u0005E!\u0001I$f_B\u000b'/];fiR{7\u000b]1sWN\u001b\u0007.Z7b\u0007>tg/\u001a:uKJT!a\u0005\u000b\u0002\u000fA\f'/];fi*\u0011QCF\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u00181\u0005IQ\r_3dkRLwN\u001c\u0006\u00033i\t1a]9m\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0013\u000e\u0003II!!\n\n\u0003;A\u000b'/];fiR{7\u000b]1sWN\u001b\u0007.Z7b\u0007>tg/\u001a:uKJ\fA#Y:tk6,')\u001b8befL5o\u0015;sS:<\u0007C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#a\u0002\"p_2,\u0017M\\\u0001\u0017CN\u001cX/\\3J]RLd'S:US6,7\u000f^1na\u00061A(\u001b8jiz\"2\u0001M\u00193!\t\u0019\u0003\u0001C\u0004'\u0007A\u0005\t\u0019A\u0014\t\u000f5\u001a\u0001\u0013!a\u0001OQ\u0011\u0001\u0007\u000e\u0005\u0006k\u0011\u0001\rAN\u0001\u0005G>tg\r\u0005\u00028u5\t\u0001H\u0003\u0002:1\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002<q\t91+\u0015'D_:4GC\u0001\u0019>\u0011\u0015)T\u00011\u0001?!\ty4)D\u0001A\u0015\t)\u0014I\u0003\u0002C9\u00051\u0001.\u00193p_BL!\u0001\u0012!\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u001d\u0019wN\u001c<feR$\"aR'\u0011\u0005![U\"A%\u000b\u0005)C\u0012!\u0002;za\u0016\u001c\u0018B\u0001'J\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\u001d\u001a\u0001\raT\u0001\u000ea\u0006\u0014\u0018/^3u'\u000eDW-\\1\u0011\u0005A#V\"A)\u000b\u0005I\u001b\u0016AB:dQ\u0016l\u0017M\u0003\u0002\u00149%\u0011Q+\u0015\u0002\f\u001b\u0016\u001c8/Y4f)f\u0004X\r\u0006\u0002H/\")aj\u0002a\u00011B\u0011\u0001+W\u0005\u00035F\u0013\u0011b\u0012:pkB$\u0016\u0010]3\u0002'\r|gN^3si\u001aKW\r\u001c3XSRDw)Z8\u0015\u0005u\u0003\u0007C\u0001%_\u0013\ty\u0016J\u0001\u0005ECR\fG+\u001f9f\u0011\u0015\t\u0007\u00021\u0001c\u0003-\u0001\u0018M]9vKR$\u0016\u0010]3\u0011\u0005A\u001b\u0017B\u00013R\u0005\u0011!\u0016\u0010]3\u0002+\r|gN^3siB\u0013\u0018.\\5uSZ,g)[3mIR\u0011Ql\u001a\u0005\u0006Q&\u0001\r![\u0001\u0006M&,G\u000e\u001a\t\u0003!*L!a[)\u0003\u001bA\u0013\u0018.\\5uSZ,G+\u001f9f\u0003E\u0019wN\u001c<feR<%o\\;q\r&,G\u000e\u001a\u000b\u0003;:DQ\u0001\u001b\u0006A\u0002a\u000bA#[:FY\u0016lWM\u001c;UsB,w+\u001b;i\u000f\u0016|GcA\u0014rg\")!o\u0003a\u0001E\u0006a!/\u001a9fCR,G\rV=qK\")Ao\u0003a\u0001k\u0006Q\u0001/\u0019:f]Rt\u0015-\\3\u0011\u0005YlhBA<|!\tA\u0018&D\u0001z\u0015\tQ\b%\u0001\u0004=e>|GOP\u0005\u0003y&\na\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011A0K\u0001!\u000f\u0016|\u0007+\u0019:rk\u0016$Hk\\*qCJ\\7k\u00195f[\u0006\u001cuN\u001c<feR,'\u000f\u0005\u0002$\u001bM\u0019Q\"a\u0002\u0011\u0007!\nI!C\u0002\u0002\f%\u0012a!\u00118z%\u00164GCAA\u0002\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0003\u0016\u0004O\u0005U1FAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0012&\u0001\u0006b]:|G/\u0019;j_:LA!!\n\u0002\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0001")
public class GeoParquetToSparkSchemaConverter
extends ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;

    public static boolean $lessinit$greater$default$2() {
        return GeoParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return GeoParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public StructType convert(MessageType parquetSchema) {
        return this.convert(parquetSchema.asGroupType());
    }

    private StructType convert(GroupType parquetSchema) {
        Buffer fields = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(parquetSchema.getFields()).asScala()).map((Function1 & Serializable)field -> {
            StructField structField;
            Type.Repetition repetition = field.getRepetition();
            if (Type.Repetition.OPTIONAL.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertFieldWithGeo((Type)field), true, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REQUIRED.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertFieldWithGeo((Type)field), false, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REPEATED.equals(repetition)) {
                ArrayType arrayType = new ArrayType(this.convertFieldWithGeo((Type)field), false);
                structField = new StructField(field.getName(), (DataType)arrayType, false, StructField$.MODULE$.apply$default$4());
            } else {
                throw new MatchError((Object)repetition);
            }
            return structField;
        });
        return StructType$.MODULE$.apply(fields.toSeq());
    }

    public DataType convertFieldWithGeo(Type parquetType) {
        DataType dataType;
        Type type = parquetType;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            dataType = this.convertPrimitiveField(primitiveType);
        } else if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            dataType = this.convertGroupField(groupType.asGroupType());
        } else {
            throw new MatchError((Object)type);
        }
        return dataType;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private DataType convertPrimitiveField(PrimitiveType field) {
        block38: {
            block44: {
                block46: {
                    block45: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block37: {
                                                typeName = field.getPrimitiveTypeName();
                                                originalType = field.getOriginalType();
                                                var12_4 = typeName;
                                                if (!PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var12_4)) break block37;
                                                var2_5 = BooleanType$.MODULE$;
                                                break block38;
                                            }
                                            if (!PrimitiveType.PrimitiveTypeName.FLOAT.equals(var12_4)) break block39;
                                            var2_5 = FloatType$.MODULE$;
                                            break block38;
                                        }
                                        if (!PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var12_4)) break block40;
                                        var2_5 = DoubleType$.MODULE$;
                                        break block38;
                                    }
                                    if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var12_4)) break block41;
                                    var13_6 = originalType;
                                    if (OriginalType.INT_8.equals(var13_6)) {
                                        var8_7 = ByteType$.MODULE$;
                                    } else if (OriginalType.INT_16.equals(var13_6)) {
                                        var8_7 = ShortType$.MODULE$;
                                    } else {
                                        var9_8 = OriginalType.INT_32.equals(var13_6) != false ? true : var13_6 == null;
                                        if (var9_8) {
                                            var8_7 = IntegerType$.MODULE$;
                                        } else if (OriginalType.DATE.equals(var13_6)) {
                                            var8_7 = DateType$.MODULE$;
                                        } else if (OriginalType.DECIMAL.equals(var13_6)) {
                                            var8_7 = GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), field, typeName);
                                        } else {
                                            if (OriginalType.UINT_8.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.UINT_16.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.UINT_32.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.TIME_MILLIS.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
                                            }
                                            throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                                        }
                                    }
                                    var2_5 = var8_7;
                                    break block38;
                                }
                                if (!PrimitiveType.PrimitiveTypeName.INT64.equals(var12_4)) break block42;
                                var14_9 = originalType;
                                var7_10 = OriginalType.INT_64.equals(var14_9) != false ? true : var14_9 == null;
                                if (var7_10) {
                                    var6_11 = LongType$.MODULE$;
                                } else if (OriginalType.DECIMAL.equals(var14_9)) {
                                    var6_11 = GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), field, typeName);
                                } else {
                                    if (OriginalType.UINT_64.equals(var14_9)) {
                                        throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                    }
                                    if (OriginalType.TIMESTAMP_MICROS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else if (OriginalType.TIMESTAMP_MILLIS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else {
                                        throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                                    }
                                }
                                var2_5 = var6_11;
                                break block38;
                            }
                            if (!PrimitiveType.PrimitiveTypeName.INT96.equals(var12_4)) break block43;
                            ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$convertPrimitiveField$2(org.apache.spark.sql.execution.datasources.parquet.GeoParquetToSparkSchemaConverter ), ()Z)((GeoParquetToSparkSchemaConverter)this), new StringBuilder(61).append("INT96 is not supported unless it's interpreted as timestamp. ").append(new StringBuilder(27).append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString()).toString());
                            var2_5 = TimestampType$.MODULE$;
                            break block38;
                        }
                        if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var12_4)) break block44;
                        var15_12 = false;
                        var16_13 = null;
                        var17_14 = originalType;
                        var5_15 = OriginalType.UTF8.equals(var17_14) != false ? true : (OriginalType.ENUM.equals(var17_14) != false ? true : OriginalType.JSON.equals(var17_14) != false);
                        if (!var5_15) break block45;
                        var4_16 /* !! */  = StringType$.MODULE$;
                        break block46;
                    }
                    if (var17_14 != null) ** GOTO lbl-1000
                    var15_12 = true;
                    var16_13 = var17_14;
                    if (GeoParquetSchemaConverter$.MODULE$.checkGeomFieldName(field.getName())) {
                        var4_16 /* !! */  = GeometryUDT$.MODULE$;
                    } else if (var15_12 && this.assumeBinaryIsString) {
                        var4_16 /* !! */  = StringType$.MODULE$;
                    } else if (var15_12) {
                        var4_16 /* !! */  = BinaryType$.MODULE$;
                    } else if (OriginalType.BSON.equals(var17_14)) {
                        var4_16 /* !! */  = BinaryType$.MODULE$;
                    } else if (OriginalType.DECIMAL.equals(var17_14)) {
                        var4_16 /* !! */  = GeoParquetToSparkSchemaConverter.makeDecimalType$1(GeoParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), field, typeName);
                    } else {
                        throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                    }
                }
                var2_5 = var4_16 /* !! */ ;
                break block38;
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var12_4)) {
                var18_17 = originalType;
                if (!OriginalType.DECIMAL.equals(var18_17)) {
                    if (OriginalType.INTERVAL.equals(var18_17)) {
                        throw GeoParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
                    }
                    throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                }
                var3_18 = GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(field.getTypeLength()), field, typeName);
                var2_5 = var3_18;
            } else {
                throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
            }
        }
        return var2_5;
    }

    private DataType convertGroupField(GroupType field) {
        return (DataType)Option$.MODULE$.apply((Object)field.getOriginalType()).fold((Function0 & Serializable)() -> this.convert(field), (Function1 & Serializable)x0$1 -> {
            ArrayType arrayType;
            OriginalType originalType = x0$1;
            if (OriginalType.LIST.equals(originalType)) {
                ArrayType arrayType2;
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Type repeatedType = field.getType(0);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                if (this.isElementTypeWithGeo(repeatedType, field.getName())) {
                    arrayType2 = new ArrayType(this.convertFieldWithGeo(repeatedType), false);
                } else {
                    Type elementType = repeatedType.asGroupType().getType(0);
                    boolean optional = elementType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType2 = new ArrayType(this.convertFieldWithGeo(elementType), optional);
                }
                arrayType = arrayType2;
            } else {
                boolean bl = OriginalType.MAP.equals(originalType) ? true : OriginalType.MAP_KEY_VALUE.equals(originalType);
                if (bl) {
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    GroupType keyValueType = field.getType(0).asGroupType();
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    Type keyType = keyValueType.getType(0);
                    Type valueType = keyValueType.getType(1);
                    boolean valueOptional = valueType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType = new MapType(this.convertFieldWithGeo(keyType), this.convertFieldWithGeo(valueType), valueOptional);
                } else {
                    throw new AnalysisException(new StringBuilder(27).append("Unrecognized Parquet type: ").append(field).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                }
            }
            return arrayType;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementTypeWithGeo(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final String typeString$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        return originalType$1 == null ? String.valueOf(typeName$1) : new StringBuilder(3).append(typeName$1).append(" (").append(originalType$1).append(")").toString();
    }

    private static final Nothing$ typeNotSupported$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new AnalysisException(new StringBuilder(28).append("Parquet type not supported: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    private static final Nothing$ typeNotImplemented$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new AnalysisException(new StringBuilder(32).append("Parquet type not yet supported: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    private static final Nothing$ illegalType$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new AnalysisException(new StringBuilder(22).append("Illegal Parquet type: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, PrimitiveType field$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        int precision = field$1.getDecimalMetadata().getPrecision();
        int scale = field$1.getDecimalMetadata().getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertPrimitiveField$2(GeoParquetToSparkSchemaConverter $this) {
        return $this.assumeInt96IsTimestamp;
    }

    public GeoParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        super(assumeBinaryIsString, assumeInt96IsTimestamp, ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3());
    }

    public GeoParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp());
    }

    public GeoParquetToSparkSchemaConverter(Configuration conf) {
        this(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))));
    }
}

