/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.showcase;

import java.awt.Color;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sedona.core.enums.FileDataSplitter;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.formatMapper.EarthdataHDFPointMapper;
import org.apache.sedona.core.spatialOperator.JoinQuery;
import org.apache.sedona.core.spatialRDD.PointRDD;
import org.apache.sedona.core.spatialRDD.PolygonRDD;
import org.apache.sedona.core.spatialRDD.RectangleRDD;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.viz.core.ImageGenerator;
import org.apache.sedona.viz.core.ImageSerializableWrapper;
import org.apache.sedona.viz.core.RasterOverlayOperator;
import org.apache.sedona.viz.extension.visualizationEffect.ChoroplethMap;
import org.apache.sedona.viz.extension.visualizationEffect.HeatMap;
import org.apache.sedona.viz.extension.visualizationEffect.ScatterPlot;
import org.apache.sedona.viz.showcase.ScalaExample$delayedInit$body;
import org.apache.sedona.viz.utils.ColorizeOption;
import org.apache.sedona.viz.utils.ImageType;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.storage.StorageLevel$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;
import scala.App;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

public final class ScalaExample$
implements App {
    public static final ScalaExample$ MODULE$ = new ScalaExample$();
    private static SparkConf sparkConf;
    private static SparkContext sparkContext;
    private static Properties prop;
    private static String resourcePath;
    private static String demoOutputPath;
    private static String scatterPlotOutputPath;
    private static String heatMapOutputPath;
    private static String choroplethMapOutputPath;
    private static String parallelFilterRenderStitchOutputPath;
    private static String earthdataScatterPlotOutputPath;
    private static String PointInputLocation;
    private static int PointOffset;
    private static FileDataSplitter PointSplitter;
    private static int PointNumPartitions;
    private static String RectangleInputLocation;
    private static int RectangleOffset;
    private static FileDataSplitter RectangleSplitter;
    private static int RectangleNumPartitions;
    private static String PolygonInputLocation;
    private static int PolygonOffset;
    private static FileDataSplitter PolygonSplitter;
    private static int PolygonNumPartitions;
    private static String LineStringInputLocation;
    private static int LineStringOffset;
    private static FileDataSplitter LineStringSplitter;
    private static int LineStringNumPartitions;
    private static Envelope USMainLandBoundary;
    private static String earthdataInputLocation;
    private static int earthdataNumPartitions;
    private static int HDFIncrement;
    private static int HDFOffset;
    private static String HDFRootGroupName;
    private static String HDFDataVariableName;
    private static String[] HDFDataVariableList;
    private static boolean HDFswitchXY;
    private static String urlPrefix;
    private static FileInputStream ConfFile;
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        App.$init$((App)MODULE$);
        MODULE$.delayedInit((Function0<BoxedUnit>)new ScalaExample$delayedInit$body(MODULE$));
        Statics.releaseFence();
    }

    public final String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public final void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public final void scala$App$_setter_$executionStart_$eq(long x$1) {
        executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        scala$App$$initCode = x$1;
    }

    public SparkConf sparkConf() {
        return sparkConf;
    }

    public SparkContext sparkContext() {
        return sparkContext;
    }

    public Properties prop() {
        return prop;
    }

    public String resourcePath() {
        return resourcePath;
    }

    public String demoOutputPath() {
        return demoOutputPath;
    }

    public String scatterPlotOutputPath() {
        return scatterPlotOutputPath;
    }

    public String heatMapOutputPath() {
        return heatMapOutputPath;
    }

    public String choroplethMapOutputPath() {
        return choroplethMapOutputPath;
    }

    public String parallelFilterRenderStitchOutputPath() {
        return parallelFilterRenderStitchOutputPath;
    }

    public String earthdataScatterPlotOutputPath() {
        return earthdataScatterPlotOutputPath;
    }

    public String PointInputLocation() {
        return PointInputLocation;
    }

    public int PointOffset() {
        return PointOffset;
    }

    public FileDataSplitter PointSplitter() {
        return PointSplitter;
    }

    public int PointNumPartitions() {
        return PointNumPartitions;
    }

    public String RectangleInputLocation() {
        return RectangleInputLocation;
    }

    public int RectangleOffset() {
        return RectangleOffset;
    }

    public FileDataSplitter RectangleSplitter() {
        return RectangleSplitter;
    }

    public int RectangleNumPartitions() {
        return RectangleNumPartitions;
    }

    public String PolygonInputLocation() {
        return PolygonInputLocation;
    }

    public int PolygonOffset() {
        return PolygonOffset;
    }

    public FileDataSplitter PolygonSplitter() {
        return PolygonSplitter;
    }

    public int PolygonNumPartitions() {
        return PolygonNumPartitions;
    }

    public String LineStringInputLocation() {
        return LineStringInputLocation;
    }

    public int LineStringOffset() {
        return LineStringOffset;
    }

    public FileDataSplitter LineStringSplitter() {
        return LineStringSplitter;
    }

    public int LineStringNumPartitions() {
        return LineStringNumPartitions;
    }

    public Envelope USMainLandBoundary() {
        return USMainLandBoundary;
    }

    public String earthdataInputLocation() {
        return earthdataInputLocation;
    }

    public int earthdataNumPartitions() {
        return earthdataNumPartitions;
    }

    public int HDFIncrement() {
        return HDFIncrement;
    }

    public int HDFOffset() {
        return HDFOffset;
    }

    public String HDFRootGroupName() {
        return HDFRootGroupName;
    }

    public String HDFDataVariableName() {
        return HDFDataVariableName;
    }

    public String[] HDFDataVariableList() {
        return HDFDataVariableList;
    }

    public boolean HDFswitchXY() {
        return HDFswitchXY;
    }

    public String urlPrefix() {
        return urlPrefix;
    }

    public FileInputStream ConfFile() {
        return ConfFile;
    }

    public void ConfFile_$eq(FileInputStream x$1) {
        ConfFile = x$1;
    }

    public boolean buildScatterPlot(String outputPath) {
        PolygonRDD spatialRDD = new PolygonRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.PolygonInputLocation(), this.PolygonSplitter(), false, Predef$.MODULE$.int2Integer(this.PolygonNumPartitions()));
        ScatterPlot visualizationOperator = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        visualizationOperator = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false, -1, -1, false, true);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        imageGenerator = new ImageGenerator();
        imageGenerator.SaveVectorImageAsLocalFile(visualizationOperator.vectorImage, outputPath, ImageType.SVG);
        visualizationOperator = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false, -1, -1, true, true);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        imageGenerator = new ImageGenerator();
        imageGenerator.SaveVectorImageAsLocalFile((JavaPairRDD<Integer, String>)visualizationOperator.distributedVectorImage, new StringBuilder(19).append("file://").append(outputPath).append("-distributed").toString(), ImageType.SVG);
        return true;
    }

    public boolean buildHeatMap(String outputPath) {
        RectangleRDD spatialRDD = new RectangleRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.RectangleInputLocation(), this.RectangleSplitter(), false, Predef$.MODULE$.int2Integer(this.RectangleNumPartitions()), StorageLevel$.MODULE$.MEMORY_ONLY());
        HeatMap visualizationOperator = new HeatMap(1000, 600, this.USMainLandBoundary(), false, 2);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public boolean buildChoroplethMap(String outputPath) {
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.PointInputLocation(), Predef$.MODULE$.int2Integer(this.PointOffset()), this.PointSplitter(), false, Predef$.MODULE$.int2Integer(this.PointNumPartitions()), StorageLevel$.MODULE$.MEMORY_ONLY());
        PolygonRDD queryRDD = new PolygonRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.PolygonInputLocation(), this.PolygonSplitter(), false, Predef$.MODULE$.int2Integer(this.PolygonNumPartitions()), StorageLevel$.MODULE$.MEMORY_ONLY());
        spatialRDD.spatialPartitioning(GridType.KDBTREE);
        queryRDD.spatialPartitioning(spatialRDD.getPartitioner());
        spatialRDD.buildIndex(IndexType.RTREE, true);
        JavaPairRDD joinResult = JoinQuery.SpatialJoinQueryCountByKey((SpatialRDD)spatialRDD, (SpatialRDD)queryRDD, (boolean)true, (boolean)false);
        ChoroplethMap visualizationOperator = new ChoroplethMap(1000, 600, this.USMainLandBoundary(), false);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.RED, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (JavaPairRDD<Polygon, Long>)joinResult);
        ScatterPlot frontImage = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false);
        frontImage.CustomizeColor(0, 0, 0, 255, Color.GREEN, true);
        frontImage.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)queryRDD);
        RasterOverlayOperator overlayOperator = new RasterOverlayOperator(visualizationOperator.rasterImage);
        overlayOperator.JoinImage(frontImage.rasterImage);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(overlayOperator.backRasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public boolean parallelFilterRenderNoStitch(String outputPath) {
        RectangleRDD spatialRDD = new RectangleRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.RectangleInputLocation(), this.RectangleSplitter(), false, Predef$.MODULE$.int2Integer(this.RectangleNumPartitions()), StorageLevel$.MODULE$.MEMORY_ONLY());
        HeatMap visualizationOperator = new HeatMap(1000, 600, this.USMainLandBoundary(), false, 2, 4, 4, true, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile((JavaPairRDD<Integer, ImageSerializableWrapper>)visualizationOperator.distributedRasterImage, outputPath, ImageType.PNG, 0, 4, 4);
        return true;
    }

    public boolean parallelFilterRenderStitch(String outputPath) {
        RectangleRDD spatialRDD = new RectangleRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.RectangleInputLocation(), this.RectangleSplitter(), false, Predef$.MODULE$.int2Integer(this.RectangleNumPartitions()), StorageLevel$.MODULE$.MEMORY_ONLY());
        HeatMap visualizationOperator = new HeatMap(1000, 600, this.USMainLandBoundary(), false, 2, 4, 4, true, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public boolean earthdataVisualization(String outputPath) {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(this.HDFIncrement(), this.HDFOffset(), this.HDFRootGroupName(), this.HDFDataVariableList(), this.HDFDataVariableName(), this.HDFswitchXY(), this.urlPrefix());
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.earthdataInputLocation(), Predef$.MODULE$.int2Integer(this.earthdataNumPartitions()), (FlatMapFunction)earthdataHDFPoint, StorageLevel$.MODULE$.MEMORY_ONLY());
        ScatterPlot visualizationOperator = new ScatterPlot(1000, 600, spatialRDD.boundaryEnvelope, ColorizeOption.EARTHOBSERVATION, false, false);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.BLUE, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public final void delayedEndpoint$org$apache$sedona$viz$showcase$ScalaExample$1() {
        sparkConf = new SparkConf().setAppName("SedonaVizDemo").setMaster("local[4]");
        sparkContext = new SparkContext(this.sparkConf());
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        prop = new Properties();
        resourcePath = "src/test/resources/";
        demoOutputPath = "target/demo";
        scatterPlotOutputPath = new StringBuilder(13).append(System.getProperty("user.dir")).append("/").append(this.demoOutputPath()).append("/scatterplot").toString();
        this.prop().load(this.ConfFile());
        heatMapOutputPath = new StringBuilder(9).append(System.getProperty("user.dir")).append("/").append(this.demoOutputPath()).append("/heatmap").toString();
        choroplethMapOutputPath = new StringBuilder(15).append(System.getProperty("user.dir")).append("/").append(this.demoOutputPath()).append("/choroplethmap").toString();
        parallelFilterRenderStitchOutputPath = new StringBuilder(35).append(System.getProperty("user.dir")).append("/").append(this.demoOutputPath()).append("/parallelfilterrenderstitchheatmap").toString();
        earthdataScatterPlotOutputPath = new StringBuilder(22).append(System.getProperty("user.dir")).append("/").append(this.demoOutputPath()).append("/earthdatascatterplot").toString();
        PointInputLocation = new StringBuilder(8).append("file://").append(System.getProperty("user.dir")).append("/").append(this.resourcePath()).append(this.prop().getProperty("inputLocation")).toString();
        PointOffset = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.prop().getProperty("offset")));
        PointSplitter = FileDataSplitter.getFileDataSplitter((String)this.prop().getProperty("splitter"));
        PointNumPartitions = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions")));
        RectangleInputLocation = new StringBuilder(8).append("file://").append(System.getProperty("user.dir")).append("/").append(this.resourcePath()).append(this.prop().getProperty("inputLocation")).toString();
        this.ConfFile_$eq(new FileInputStream(new StringBuilder(28).append(this.resourcePath()).append("babylon.rectangle.properties").toString()));
        this.prop().load(this.ConfFile());
        RectangleOffset = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.prop().getProperty("offset")));
        RectangleSplitter = FileDataSplitter.getFileDataSplitter((String)this.prop().getProperty("splitter"));
        RectangleNumPartitions = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions")));
        PolygonInputLocation = new StringBuilder(8).append("file://").append(System.getProperty("user.dir")).append("/").append(this.resourcePath()).append(this.prop().getProperty("inputLocation")).toString();
        this.ConfFile_$eq(new FileInputStream(new StringBuilder(26).append(this.resourcePath()).append("babylon.polygon.properties").toString()));
        this.prop().load(this.ConfFile());
        PolygonOffset = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.prop().getProperty("offset")));
        PolygonSplitter = FileDataSplitter.getFileDataSplitter((String)this.prop().getProperty("splitter"));
        PolygonNumPartitions = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions")));
        LineStringInputLocation = new StringBuilder(8).append("file://").append(System.getProperty("user.dir")).append("/").append(this.resourcePath()).append(this.prop().getProperty("inputLocation")).toString();
        this.ConfFile_$eq(new FileInputStream(new StringBuilder(29).append(this.resourcePath()).append("babylon.linestring.properties").toString()));
        this.prop().load(this.ConfFile());
        LineStringOffset = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.prop().getProperty("offset")));
        LineStringSplitter = FileDataSplitter.getFileDataSplitter((String)this.prop().getProperty("splitter"));
        LineStringNumPartitions = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions")));
        USMainLandBoundary = new Envelope(-126.79018, -64.630926, 24.863836, 50.0);
        earthdataInputLocation = new StringBuilder(35).append(System.getProperty("user.dir")).append("/src/test/resources/modis/modis.csv").toString();
        earthdataNumPartitions = 5;
        HDFIncrement = 5;
        HDFOffset = 2;
        HDFRootGroupName = "MOD_Swath_LST";
        HDFDataVariableName = "LST";
        HDFDataVariableList = (String[])((Object[])new String[]{"LST", "QC", "Error_LST", "Emis_31", "Emis_32"});
        HDFswitchXY = true;
        urlPrefix = new StringBuilder(26).append(System.getProperty("user.dir")).append("/src/test/resources/modis/").toString();
        ConfFile = new FileInputStream(new StringBuilder(24).append(this.resourcePath()).append("babylon.point.properties").toString());
        if (this.buildScatterPlot(this.scatterPlotOutputPath()) && this.buildHeatMap(this.heatMapOutputPath()) && this.buildChoroplethMap(this.choroplethMapOutputPath()) && this.parallelFilterRenderStitch(new StringBuilder(9).append(this.parallelFilterRenderStitchOutputPath()).append("-stitched").toString()) && this.parallelFilterRenderNoStitch(this.parallelFilterRenderStitchOutputPath()) && this.earthdataVisualization(this.earthdataScatterPlotOutputPath())) {
            System.out.println("All 5 Demos have passed.");
        } else {
            System.out.println("Demos failed.");
        }
    }

    private ScalaExample$() {
    }
}

