/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.spatialPartitioning.KDB;
import org.apache.sedona.core.spatialPartitioning.QuadtreePartitioning;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Tuple2;

public abstract class PartitioningUtils {
    public abstract Iterator<Tuple2<Integer, Geometry>> placeObject(Geometry var1);

    public abstract Set<Integer> getKeys(Geometry var1);

    public abstract List<Envelope> fetchLeafZones();

    public static PartitioningUtils getPartitioner(List<Geometry> samples, GridType gridType, Envelope boundaryEnvelope, int resolution) {
        ArrayList<Envelope> sampleEnvelopes = new ArrayList<Envelope>();
        for (Geometry geom : samples) {
            sampleEnvelopes.add(geom.getEnvelopeInternal());
        }
        Envelope paddedBoundary = new Envelope(boundaryEnvelope.getMinX(), boundaryEnvelope.getMaxX() + 0.01, boundaryEnvelope.getMinY(), boundaryEnvelope.getMaxY() + 0.01);
        PartitioningUtils partitioner = null;
        switch (gridType) {
            case EQUALGRID: {
                int minLevel = (int)Math.max(Math.log(resolution) / Math.log(4.0), 0.0);
                QuadtreePartitioning quadtreePartitioning = null;
                try {
                    quadtreePartitioning = new QuadtreePartitioning(new ArrayList<Envelope>(), paddedBoundary, resolution, minLevel);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                partitioner = quadtreePartitioning.getPartitionTree();
                break;
            }
            case QUADTREE: {
                QuadtreePartitioning quadtreePartitioning = null;
                try {
                    quadtreePartitioning = new QuadtreePartitioning(sampleEnvelopes, paddedBoundary, resolution);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                partitioner = quadtreePartitioning.getPartitionTree();
                break;
            }
            case KDBTREE: {
                KDB tree = new KDB(sampleEnvelopes.size() / resolution, resolution, paddedBoundary);
                for (Envelope sample : sampleEnvelopes) {
                    tree.insert(sample);
                }
                tree.assignLeafIds();
                partitioner = tree;
                break;
            }
            default: {
                try {
                    throw new Exception("[AbstractSpatialRDD][spatialPartitioning] Unsupported spatial partitioning method. The following partitioning methods are not longer supported: R-Tree, Hilbert curve, Voronoi");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        return partitioner;
    }

    public static PartitioningUtils getPartitioner(Envelope boundaryEnvelope, int resolution) {
        return PartitioningUtils.getPartitioner(new ArrayList<Geometry>(), GridType.EQUALGRID, boundaryEnvelope, resolution);
    }
}

