/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.dag.actions;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.Config;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;

public abstract class AbstractAction
implements Action {
    private String name;
    private transient List<Action> upstreams = new ArrayList<Action>();
    private long id;
    private int parallelism = 1;
    private final Set<URL> jarUrls;
    private final Config config;
    private final Set<ConnectorJarIdentifier> connectorJarIdentifiers;

    protected AbstractAction(long id, @NonNull String name, @NonNull Set<URL> jarUrls, @NonNull Set<ConnectorJarIdentifier> connectorJarIdentifiers) {
        this(id, name, new ArrayList<Action>(), jarUrls, connectorJarIdentifiers);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (jarUrls == null) {
            throw new NullPointerException("jarUrls is marked non-null but is null");
        }
        if (connectorJarIdentifiers == null) {
            throw new NullPointerException("connectorJarIdentifiers is marked non-null but is null");
        }
    }

    protected AbstractAction(long id, @NonNull String name, @NonNull List<Action> upstreams, @NonNull Set<URL> jarUrls, @NonNull Set<ConnectorJarIdentifier> connectorJarIdentifiers) {
        this(id, name, upstreams, jarUrls, connectorJarIdentifiers, null);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (upstreams == null) {
            throw new NullPointerException("upstreams is marked non-null but is null");
        }
        if (jarUrls == null) {
            throw new NullPointerException("jarUrls is marked non-null but is null");
        }
        if (connectorJarIdentifiers == null) {
            throw new NullPointerException("connectorJarIdentifiers is marked non-null but is null");
        }
    }

    protected AbstractAction(long id, @NonNull String name, @NonNull List<Action> upstreams, @NonNull Set<URL> jarUrls, @NonNull Set<ConnectorJarIdentifier> connectorJarIdentifiers, Config config) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (upstreams == null) {
            throw new NullPointerException("upstreams is marked non-null but is null");
        }
        if (jarUrls == null) {
            throw new NullPointerException("jarUrls is marked non-null but is null");
        }
        if (connectorJarIdentifiers == null) {
            throw new NullPointerException("connectorJarIdentifiers is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.upstreams = upstreams;
        this.jarUrls = jarUrls;
        this.connectorJarIdentifiers = connectorJarIdentifiers;
        this.config = config;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Override
    @NonNull
    public List<Action> getUpstream() {
        return this.upstreams;
    }

    @Override
    public void addUpstream(@NonNull Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.upstreams.add(action);
    }

    @Override
    public int getParallelism() {
        return this.parallelism;
    }

    @Override
    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Set<URL> getJarUrls() {
        return this.jarUrls;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Set<ConnectorJarIdentifier> getConnectorJarIdentifiers() {
        return this.connectorJarIdentifiers;
    }
}

