/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.annotation.Nullable;

public final class JetGetJobConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16648192;
    public static final int RESPONSE_MESSAGE_TYPE = 16648193;
    private static final int REQUEST_JOB_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_LIGHT_JOB_COORDINATOR_FIELD_OFFSET = 24;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 41;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private JetGetJobConfigCodec() {
    }

    public static ClientMessage encodeRequest(long jobId, @Nullable UUID lightJobCoordinator) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Jet.GetJobConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[41], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16648192);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, jobId);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 24, lightJobCoordinator);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.jobId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        if (initialFrame.content.length >= 41) {
            request.lightJobCoordinator = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 24);
            request.isLightJobCoordinatorExists = true;
        } else {
            request.isLightJobCoordinatorExists = false;
        }
        return request;
    }

    public static ClientMessage encodeResponse(Data response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16648193);
        clientMessage.add(initialFrame);
        DataCodec.encode(clientMessage, response);
        return clientMessage;
    }

    public static Data decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        iterator.next();
        return DataCodec.decode(iterator);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public long jobId;
        @Nullable
        public UUID lightJobCoordinator;
        public boolean isLightJobCoordinatorExists;
    }
}

