/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.plugin.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.PluginRegistrySupport;

public class SimplePluginRegistry<T extends Plugin<S>, S>
extends PluginRegistrySupport<T, S> {
    protected SimplePluginRegistry(List<? extends T> plugins) {
        super(plugins);
    }

    public static <S, T extends Plugin<S>> SimplePluginRegistry<T, S> create() {
        return SimplePluginRegistry.create(Collections.emptyList());
    }

    public static <S, T extends Plugin<S>> SimplePluginRegistry<T, S> create(List<? extends T> plugins) {
        return new SimplePluginRegistry<T, S>(plugins);
    }

    @Override
    public List<T> getPlugins() {
        return Collections.unmodifiableList(super.getPlugins());
    }

    @Override
    public T getPluginFor(S delimiter) {
        for (Plugin plugin : super.getPlugins()) {
            if (plugin == null || !plugin.supports(delimiter)) continue;
            return (T)plugin;
        }
        return null;
    }

    @Override
    public List<T> getPluginsFor(S delimiter) {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        for (Plugin plugin : super.getPlugins()) {
            if (plugin == null || !plugin.supports(delimiter)) continue;
            result.add(plugin);
        }
        return result;
    }

    @Override
    public <E extends Exception> T getPluginFor(S delimiter, E ex) throws E {
        T plugin = this.getPluginFor(delimiter);
        if (null == plugin) {
            throw ex;
        }
        return plugin;
    }

    @Override
    public <E extends Exception> List<T> getPluginsFor(S delimiter, E ex) throws E {
        List<T> result = this.getPluginsFor(delimiter);
        if (result.isEmpty()) {
            throw ex;
        }
        return result;
    }

    @Override
    public T getPluginFor(S delimiter, T plugin) {
        T candidate = this.getPluginFor(delimiter);
        return null == candidate ? plugin : candidate;
    }

    @Override
    public List<T> getPluginsFor(S delimiter, List<? extends T> plugins) {
        ArrayList<T> candidates = this.getPluginsFor(delimiter);
        return candidates.isEmpty() ? new ArrayList<T>(plugins) : candidates;
    }

    @Override
    public int countPlugins() {
        return super.getPlugins().size();
    }

    @Override
    public boolean contains(T plugin) {
        return super.getPlugins().contains(plugin);
    }

    @Override
    public boolean hasPluginFor(S delimiter) {
        return null != this.getPluginFor(delimiter);
    }
}

