/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.TableSchemaReq;
import org.apache.seatunnel.app.domain.response.job.TableSchemaRes;
import org.apache.seatunnel.app.service.ITableSchemaService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/seatunnel/api/v1/job/table"})
public class TableSchemaController {
    @Resource
    private ITableSchemaService tableSchemaService;

    @PostMapping(value={"/schema"})
    Result<TableSchemaRes> querySchemaMapping(@ApiParam(value="datasource plugin name", required=true) @RequestParam String pluginName, @ApiParam(value="task info", required=true) @RequestBody TableSchemaReq tableSchemaReq) {
        return Result.success(this.tableSchemaService.getSeaTunnelSchema(pluginName, tableSchemaReq));
    }

    @PostMapping(value={"/check"})
    @ApiOperation(value="check database and table is exist", httpMethod="POST")
    public Result<DataSourceOption> checkDatabaseAndTable(@RequestParam String datasourceId, @RequestBody DataSourceOption dataSourceOption) {
        return Result.success(this.tableSchemaService.checkDatabaseAndTable(datasourceId, dataSourceOption));
    }

    @GetMapping(value={"/column-projection"})
    Result<Boolean> queryColumnProjection(@ApiParam(value="datasource plugin name", required=true) @RequestParam String pluginName) {
        return Result.success(this.tableSchemaService.getColumnProjection(pluginName));
    }
}

