/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class ConcurrencyDetection {
    private final boolean enabled;

    private ConcurrencyDetection(boolean enabled) {
        this.enabled = enabled;
    }

    public abstract boolean isDetected();

    public abstract void onDetected();

    public boolean enabled() {
        return this.enabled;
    }

    public static ConcurrencyDetection createEnabled(long durationMs) {
        return new EnabledConcurrencyDetection(durationMs);
    }

    public static ConcurrencyDetection createDisabled() {
        return new DisabledConcurrencyDetection();
    }

    private static final class EnabledConcurrencyDetection
    extends ConcurrencyDetection {
        private final long windowNanos;
        private final AtomicLong expirationNanosRef = new AtomicLong(System.nanoTime());
        private final long halfWindowNanos;

        private EnabledConcurrencyDetection(long delayMs) {
            super(true);
            this.windowNanos = TimeUnit.MILLISECONDS.toNanos(delayMs);
            this.halfWindowNanos = this.windowNanos / 2L;
        }

        @Override
        public boolean isDetected() {
            return System.nanoTime() - this.expirationNanosRef.get() < 0L;
        }

        @Override
        public void onDetected() {
            long expirationNanos;
            long nowNanos = System.nanoTime();
            if (nowNanos - ((expirationNanos = this.expirationNanosRef.get()) - this.halfWindowNanos) > 0L) {
                this.expirationNanosRef.lazySet(nowNanos + this.windowNanos);
            }
        }
    }

    private static final class DisabledConcurrencyDetection
    extends ConcurrencyDetection {
        private DisabledConcurrencyDetection() {
            super(false);
        }

        @Override
        public boolean isDetected() {
            return true;
        }

        @Override
        public void onDetected() {
        }
    }
}

